@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.kotlin.outputs.CloudEndpointChangeEnumerationStatusResponse
import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.storagesync.kotlin.outputs.CloudEndpointChangeEnumerationStatusResponse.Companion.toKotlin as cloudEndpointChangeEnumerationStatusResponseToKotlin
import com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CloudEndpoint].
 */
@PulumiTagMarker
public class CloudEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudEndpointArgs = CloudEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudEndpointArgsBuilder.() -> Unit) {
        val builder = CloudEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CloudEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.storagesync.CloudEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudEndpoint(builtJavaResource)
    }
}

/**
 * Cloud Endpoint object.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2018-04-02, 2018-07-01, 2018-10-01, 2022-09-01.
 * ## Example Usage
 * ### CloudEndpoints_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudEndpoint = new AzureNative.StorageSync.CloudEndpoint("cloudEndpoint", new()
 *     {
 *         AzureFileShareName = "cvcloud-afscv-0719-058-a94a1354-a1fd-4e9a-9a50-919fad8c4ba4",
 *         CloudEndpointName = "SampleCloudEndpoint_1",
 *         FriendlyName = "ankushbsubscriptionmgmtmab",
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         StorageAccountResourceId = "/subscriptions/744f4d70-6d17-4921-8970-a765d14f763f/resourceGroups/tminienv59svc/providers/Microsoft.Storage/storageAccounts/tminienv59storage",
 *         StorageAccountTenantId = "\"72f988bf-86f1-41af-91ab-2d7cd011db47\"",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *         SyncGroupName = "SampleSyncGroup_1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewCloudEndpoint(ctx, "cloudEndpoint", &storagesync.CloudEndpointArgs{
 * 			AzureFileShareName:       pulumi.String("cvcloud-afscv-0719-058-a94a1354-a1fd-4e9a-9a50-919fad8c4ba4"),
 * 			CloudEndpointName:        pulumi.String("SampleCloudEndpoint_1"),
 * 			FriendlyName:             pulumi.String("ankushbsubscriptionmgmtmab"),
 * 			ResourceGroupName:        pulumi.String("SampleResourceGroup_1"),
 * 			StorageAccountResourceId: pulumi.String("/subscriptions/744f4d70-6d17-4921-8970-a765d14f763f/resourceGroups/tminienv59svc/providers/Microsoft.Storage/storageAccounts/tminienv59storage"),
 * 			StorageAccountTenantId:   pulumi.String("\"72f988bf-86f1-41af-91ab-2d7cd011db47\""),
 * 			StorageSyncServiceName:   pulumi.String("SampleStorageSyncService_1"),
 * 			SyncGroupName:            pulumi.String("SampleSyncGroup_1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.CloudEndpoint;
 * import com.pulumi.azurenative.storagesync.CloudEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudEndpoint = new CloudEndpoint("cloudEndpoint", CloudEndpointArgs.builder()
 *             .azureFileShareName("cvcloud-afscv-0719-058-a94a1354-a1fd-4e9a-9a50-919fad8c4ba4")
 *             .cloudEndpointName("SampleCloudEndpoint_1")
 *             .friendlyName("ankushbsubscriptionmgmtmab")
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .storageAccountResourceId("/subscriptions/744f4d70-6d17-4921-8970-a765d14f763f/resourceGroups/tminienv59svc/providers/Microsoft.Storage/storageAccounts/tminienv59storage")
 *             .storageAccountTenantId("\"72f988bf-86f1-41af-91ab-2d7cd011db47\"")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .syncGroupName("SampleSyncGroup_1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:CloudEndpoint SampleCloudEndpoint_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}/syncGroups/{syncGroupName}/cloudEndpoints/{cloudEndpointName}
 * ```
 */
public class CloudEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.storagesync.CloudEndpoint,
) : KotlinCustomResource(javaResource, CloudEndpointMapper) {
    /**
     * Azure file share name
     */
    public val azureFileShareName: Output<String>?
        get() = javaResource.azureFileShareName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Backup Enabled
     */
    public val backupEnabled: Output<String>
        get() = javaResource.backupEnabled().applyValue({ args0 -> args0 })

    /**
     * Cloud endpoint change enumeration status
     */
    public val changeEnumerationStatus: Output<CloudEndpointChangeEnumerationStatusResponse>
        get() = javaResource.changeEnumerationStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                cloudEndpointChangeEnumerationStatusResponseToKotlin(args0)
            })
        })

    /**
     * Friendly Name
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Last Operation Name
     */
    public val lastOperationName: Output<String>?
        get() = javaResource.lastOperationName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * CloudEndpoint lastWorkflowId
     */
    public val lastWorkflowId: Output<String>?
        get() = javaResource.lastWorkflowId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Partnership Id
     */
    public val partnershipId: Output<String>?
        get() = javaResource.partnershipId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * CloudEndpoint Provisioning State
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Storage Account Resource Id
     */
    public val storageAccountResourceId: Output<String>?
        get() = javaResource.storageAccountResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Storage Account Tenant Id
     */
    public val storageAccountTenantId: Output<String>?
        get() = javaResource.storageAccountTenantId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CloudEndpointMapper : ResourceMapper<CloudEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagesync.CloudEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): CloudEndpoint = CloudEndpoint(
        javaResource as
            com.pulumi.azurenative.storagesync.CloudEndpoint,
    )
}

/**
 * @see [CloudEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudEndpoint].
 */
public suspend fun cloudEndpoint(
    name: String,
    block: suspend CloudEndpointResourceBuilder.() -> Unit,
): CloudEndpoint {
    val builder = CloudEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudEndpoint(name: String): CloudEndpoint {
    val builder = CloudEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
