@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin

import com.pulumi.azurenative.storagesync.ServerEndpointArgs.builder
import com.pulumi.azurenative.storagesync.kotlin.enums.FeatureStatus
import com.pulumi.azurenative.storagesync.kotlin.enums.InitialDownloadPolicy
import com.pulumi.azurenative.storagesync.kotlin.enums.InitialUploadPolicy
import com.pulumi.azurenative.storagesync.kotlin.enums.LocalCacheMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Server Endpoint object.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2017-06-05-preview, 2018-04-02, 2018-07-01, 2018-10-01, 2019-10-01, 2022-09-01.
 * ## Example Usage
 * ### ServerEndpoints_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverEndpoint = new AzureNative.StorageSync.ServerEndpoint("serverEndpoint", new()
 *     {
 *         CloudTiering = AzureNative.StorageSync.FeatureStatus.Off,
 *         InitialDownloadPolicy = AzureNative.StorageSync.InitialDownloadPolicy.NamespaceThenModifiedFiles,
 *         InitialUploadPolicy = AzureNative.StorageSync.InitialUploadPolicy.ServerAuthoritative,
 *         LocalCacheMode = AzureNative.StorageSync.LocalCacheMode.UpdateLocallyCachedFiles,
 *         OfflineDataTransfer = AzureNative.StorageSync.FeatureStatus.@On,
 *         OfflineDataTransferShareName = "myfileshare",
 *         ResourceGroupName = "SampleResourceGroup_1",
 *         ServerEndpointName = "SampleServerEndpoint_1",
 *         ServerLocalPath = "D:\\SampleServerEndpoint_1",
 *         ServerResourceId = "/subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/registeredServers/080d4133-bdb5-40a0-96a0-71a6057bfe9a",
 *         StorageSyncServiceName = "SampleStorageSyncService_1",
 *         SyncGroupName = "SampleSyncGroup_1",
 *         TierFilesOlderThanDays = 0,
 *         VolumeFreeSpacePercent = 100,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagesync/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagesync.NewServerEndpoint(ctx, "serverEndpoint", &storagesync.ServerEndpointArgs{
 * 			CloudTiering:                 pulumi.String(storagesync.FeatureStatusOff),
 * 			InitialDownloadPolicy:        pulumi.String(storagesync.InitialDownloadPolicyNamespaceThenModifiedFiles),
 * 			InitialUploadPolicy:          pulumi.String(storagesync.InitialUploadPolicyServerAuthoritative),
 * 			LocalCacheMode:               pulumi.String(storagesync.LocalCacheModeUpdateLocallyCachedFiles),
 * 			OfflineDataTransfer:          pulumi.String(storagesync.FeatureStatusOn),
 * 			OfflineDataTransferShareName: pulumi.String("myfileshare"),
 * 			ResourceGroupName:            pulumi.String("SampleResourceGroup_1"),
 * 			ServerEndpointName:           pulumi.String("SampleServerEndpoint_1"),
 * 			ServerLocalPath:              pulumi.String("D:\\SampleServerEndpoint_1"),
 * 			ServerResourceId:             pulumi.String("/subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/registeredServers/080d4133-bdb5-40a0-96a0-71a6057bfe9a"),
 * 			StorageSyncServiceName:       pulumi.String("SampleStorageSyncService_1"),
 * 			SyncGroupName:                pulumi.String("SampleSyncGroup_1"),
 * 			TierFilesOlderThanDays:       pulumi.Int(0),
 * 			VolumeFreeSpacePercent:       pulumi.Int(100),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagesync.ServerEndpoint;
 * import com.pulumi.azurenative.storagesync.ServerEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverEndpoint = new ServerEndpoint("serverEndpoint", ServerEndpointArgs.builder()
 *             .cloudTiering("off")
 *             .initialDownloadPolicy("NamespaceThenModifiedFiles")
 *             .initialUploadPolicy("ServerAuthoritative")
 *             .localCacheMode("UpdateLocallyCachedFiles")
 *             .offlineDataTransfer("on")
 *             .offlineDataTransferShareName("myfileshare")
 *             .resourceGroupName("SampleResourceGroup_1")
 *             .serverEndpointName("SampleServerEndpoint_1")
 *             .serverLocalPath("D:\\SampleServerEndpoint_1")
 *             .serverResourceId("/subscriptions/52b8da2f-61e0-4a1f-8dde-336911f367fb/resourceGroups/SampleResourceGroup_1/providers/Microsoft.StorageSync/storageSyncServices/SampleStorageSyncService_1/registeredServers/080d4133-bdb5-40a0-96a0-71a6057bfe9a")
 *             .storageSyncServiceName("SampleStorageSyncService_1")
 *             .syncGroupName("SampleSyncGroup_1")
 *             .tierFilesOlderThanDays(0)
 *             .volumeFreeSpacePercent(100)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagesync:ServerEndpoint SampleServerEndpoint_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageSync/storageSyncServices/{storageSyncServiceName}/syncGroups/{syncGroupName}/serverEndpoints/{serverEndpointName}
 * ```
 * @property cloudTiering Cloud Tiering.
 * @property friendlyName Friendly Name
 * @property initialDownloadPolicy Policy for how namespace and files are recalled during FastDr.
 * @property initialUploadPolicy Policy for how the initial upload sync session is performed.
 * @property localCacheMode Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
 * @property offlineDataTransfer Offline data transfer
 * @property offlineDataTransferShareName Offline data transfer share name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverEndpointName Name of Server Endpoint object.
 * @property serverLocalPath Server Local path.
 * @property serverResourceId Server Resource Id.
 * @property storageSyncServiceName Name of Storage Sync Service resource.
 * @property syncGroupName Name of Sync Group resource.
 * @property tierFilesOlderThanDays Tier files older than days.
 * @property volumeFreeSpacePercent Level of free space to be maintained by Cloud Tiering if it is enabled.
 */
public data class ServerEndpointArgs(
    public val cloudTiering: Output<Either<String, FeatureStatus>>? = null,
    public val friendlyName: Output<String>? = null,
    public val initialDownloadPolicy: Output<Either<String, InitialDownloadPolicy>>? = null,
    public val initialUploadPolicy: Output<Either<String, InitialUploadPolicy>>? = null,
    public val localCacheMode: Output<Either<String, LocalCacheMode>>? = null,
    public val offlineDataTransfer: Output<Either<String, FeatureStatus>>? = null,
    public val offlineDataTransferShareName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverEndpointName: Output<String>? = null,
    public val serverLocalPath: Output<String>? = null,
    public val serverResourceId: Output<String>? = null,
    public val storageSyncServiceName: Output<String>? = null,
    public val syncGroupName: Output<String>? = null,
    public val tierFilesOlderThanDays: Output<Int>? = null,
    public val volumeFreeSpacePercent: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagesync.ServerEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.storagesync.ServerEndpointArgs =
        com.pulumi.azurenative.storagesync.ServerEndpointArgs.builder()
            .cloudTiering(
                cloudTiering?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .initialDownloadPolicy(
                initialDownloadPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .initialUploadPolicy(
                initialUploadPolicy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .localCacheMode(
                localCacheMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .offlineDataTransfer(
                offlineDataTransfer?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .offlineDataTransferShareName(offlineDataTransferShareName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverEndpointName(serverEndpointName?.applyValue({ args0 -> args0 }))
            .serverLocalPath(serverLocalPath?.applyValue({ args0 -> args0 }))
            .serverResourceId(serverResourceId?.applyValue({ args0 -> args0 }))
            .storageSyncServiceName(storageSyncServiceName?.applyValue({ args0 -> args0 }))
            .syncGroupName(syncGroupName?.applyValue({ args0 -> args0 }))
            .tierFilesOlderThanDays(tierFilesOlderThanDays?.applyValue({ args0 -> args0 }))
            .volumeFreeSpacePercent(volumeFreeSpacePercent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerEndpointArgs].
 */
@PulumiTagMarker
public class ServerEndpointArgsBuilder internal constructor() {
    private var cloudTiering: Output<Either<String, FeatureStatus>>? = null

    private var friendlyName: Output<String>? = null

    private var initialDownloadPolicy: Output<Either<String, InitialDownloadPolicy>>? = null

    private var initialUploadPolicy: Output<Either<String, InitialUploadPolicy>>? = null

    private var localCacheMode: Output<Either<String, LocalCacheMode>>? = null

    private var offlineDataTransfer: Output<Either<String, FeatureStatus>>? = null

    private var offlineDataTransferShareName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverEndpointName: Output<String>? = null

    private var serverLocalPath: Output<String>? = null

    private var serverResourceId: Output<String>? = null

    private var storageSyncServiceName: Output<String>? = null

    private var syncGroupName: Output<String>? = null

    private var tierFilesOlderThanDays: Output<Int>? = null

    private var volumeFreeSpacePercent: Output<Int>? = null

    /**
     * @param value Cloud Tiering.
     */
    @JvmName("gfkhpgmuymtkhxss")
    public suspend fun cloudTiering(`value`: Output<Either<String, FeatureStatus>>) {
        this.cloudTiering = value
    }

    /**
     * @param value Friendly Name
     */
    @JvmName("wschqurkfachxlpr")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Policy for how namespace and files are recalled during FastDr.
     */
    @JvmName("tqacgjddgjuulfsn")
    public suspend fun initialDownloadPolicy(`value`: Output<Either<String, InitialDownloadPolicy>>) {
        this.initialDownloadPolicy = value
    }

    /**
     * @param value Policy for how the initial upload sync session is performed.
     */
    @JvmName("rpikunddeixxuuiq")
    public suspend fun initialUploadPolicy(`value`: Output<Either<String, InitialUploadPolicy>>) {
        this.initialUploadPolicy = value
    }

    /**
     * @param value Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
     */
    @JvmName("updfepgcblrfxggl")
    public suspend fun localCacheMode(`value`: Output<Either<String, LocalCacheMode>>) {
        this.localCacheMode = value
    }

    /**
     * @param value Offline data transfer
     */
    @JvmName("bnvpuylyqxfqtwsg")
    public suspend fun offlineDataTransfer(`value`: Output<Either<String, FeatureStatus>>) {
        this.offlineDataTransfer = value
    }

    /**
     * @param value Offline data transfer share name
     */
    @JvmName("wfpohncivsugcxgx")
    public suspend fun offlineDataTransferShareName(`value`: Output<String>) {
        this.offlineDataTransferShareName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pvvqdersbwpshipp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Server Endpoint object.
     */
    @JvmName("xoqpcmichuxvjyly")
    public suspend fun serverEndpointName(`value`: Output<String>) {
        this.serverEndpointName = value
    }

    /**
     * @param value Server Local path.
     */
    @JvmName("eqcucfaullgshxkd")
    public suspend fun serverLocalPath(`value`: Output<String>) {
        this.serverLocalPath = value
    }

    /**
     * @param value Server Resource Id.
     */
    @JvmName("gpyuiwyichqdtjqf")
    public suspend fun serverResourceId(`value`: Output<String>) {
        this.serverResourceId = value
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("ftvrpnjsolvtieeh")
    public suspend fun storageSyncServiceName(`value`: Output<String>) {
        this.storageSyncServiceName = value
    }

    /**
     * @param value Name of Sync Group resource.
     */
    @JvmName("hiqiarxberypnhoy")
    public suspend fun syncGroupName(`value`: Output<String>) {
        this.syncGroupName = value
    }

    /**
     * @param value Tier files older than days.
     */
    @JvmName("ofehwmeywqobjxkx")
    public suspend fun tierFilesOlderThanDays(`value`: Output<Int>) {
        this.tierFilesOlderThanDays = value
    }

    /**
     * @param value Level of free space to be maintained by Cloud Tiering if it is enabled.
     */
    @JvmName("tojvdlqjgtwpythy")
    public suspend fun volumeFreeSpacePercent(`value`: Output<Int>) {
        this.volumeFreeSpacePercent = value
    }

    /**
     * @param value Cloud Tiering.
     */
    @JvmName("uttxqmwkwnmkdwmx")
    public suspend fun cloudTiering(`value`: Either<String, FeatureStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudTiering = mapped
    }

    /**
     * @param value Cloud Tiering.
     */
    @JvmName("yljansrsgiyklkev")
    public fun cloudTiering(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FeatureStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudTiering = mapped
    }

    /**
     * @param value Cloud Tiering.
     */
    @JvmName("odlpiqbpgleicdus")
    public fun cloudTiering(`value`: FeatureStatus) {
        val toBeMapped = Either.ofRight<String, FeatureStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudTiering = mapped
    }

    /**
     * @param value Friendly Name
     */
    @JvmName("fxfcpmgerxvpnrmc")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Policy for how namespace and files are recalled during FastDr.
     */
    @JvmName("itnouhkwhiywjmiw")
    public suspend fun initialDownloadPolicy(`value`: Either<String, InitialDownloadPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDownloadPolicy = mapped
    }

    /**
     * @param value Policy for how namespace and files are recalled during FastDr.
     */
    @JvmName("fmgqilighohuulxd")
    public fun initialDownloadPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InitialDownloadPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialDownloadPolicy = mapped
    }

    /**
     * @param value Policy for how namespace and files are recalled during FastDr.
     */
    @JvmName("htjgmsstveunejam")
    public fun initialDownloadPolicy(`value`: InitialDownloadPolicy) {
        val toBeMapped = Either.ofRight<String, InitialDownloadPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialDownloadPolicy = mapped
    }

    /**
     * @param value Policy for how the initial upload sync session is performed.
     */
    @JvmName("odidcrdiiuwijjsb")
    public suspend fun initialUploadPolicy(`value`: Either<String, InitialUploadPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialUploadPolicy = mapped
    }

    /**
     * @param value Policy for how the initial upload sync session is performed.
     */
    @JvmName("axkonqluqqvkqapg")
    public fun initialUploadPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InitialUploadPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialUploadPolicy = mapped
    }

    /**
     * @param value Policy for how the initial upload sync session is performed.
     */
    @JvmName("alylgbjhahlvikiw")
    public fun initialUploadPolicy(`value`: InitialUploadPolicy) {
        val toBeMapped = Either.ofRight<String, InitialUploadPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialUploadPolicy = mapped
    }

    /**
     * @param value Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
     */
    @JvmName("qmecwlbgjyhusbkv")
    public suspend fun localCacheMode(`value`: Either<String, LocalCacheMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localCacheMode = mapped
    }

    /**
     * @param value Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
     */
    @JvmName("dpoheoophrrvripp")
    public fun localCacheMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LocalCacheMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localCacheMode = mapped
    }

    /**
     * @param value Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
     */
    @JvmName("kbiywkmeyjaedfxn")
    public fun localCacheMode(`value`: LocalCacheMode) {
        val toBeMapped = Either.ofRight<String, LocalCacheMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localCacheMode = mapped
    }

    /**
     * @param value Offline data transfer
     */
    @JvmName("lrjmgvathufsyahn")
    public suspend fun offlineDataTransfer(`value`: Either<String, FeatureStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offlineDataTransfer = mapped
    }

    /**
     * @param value Offline data transfer
     */
    @JvmName("ewleqrbxudkmqfbh")
    public fun offlineDataTransfer(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FeatureStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offlineDataTransfer = mapped
    }

    /**
     * @param value Offline data transfer
     */
    @JvmName("orgcpuxxyhppbbtn")
    public fun offlineDataTransfer(`value`: FeatureStatus) {
        val toBeMapped = Either.ofRight<String, FeatureStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offlineDataTransfer = mapped
    }

    /**
     * @param value Offline data transfer share name
     */
    @JvmName("homsuykdenkwxnad")
    public suspend fun offlineDataTransferShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offlineDataTransferShareName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("abiyxfggiwnylwmm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Server Endpoint object.
     */
    @JvmName("utbrohgdvsyxeoxv")
    public suspend fun serverEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverEndpointName = mapped
    }

    /**
     * @param value Server Local path.
     */
    @JvmName("qiafwefptohxkwoo")
    public suspend fun serverLocalPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverLocalPath = mapped
    }

    /**
     * @param value Server Resource Id.
     */
    @JvmName("gbjwoseixiboxmrx")
    public suspend fun serverResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverResourceId = mapped
    }

    /**
     * @param value Name of Storage Sync Service resource.
     */
    @JvmName("yvhysknfwfivyevb")
    public suspend fun storageSyncServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSyncServiceName = mapped
    }

    /**
     * @param value Name of Sync Group resource.
     */
    @JvmName("jgnokntcdmuxkril")
    public suspend fun syncGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncGroupName = mapped
    }

    /**
     * @param value Tier files older than days.
     */
    @JvmName("mgubsopsegxbfxvt")
    public suspend fun tierFilesOlderThanDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierFilesOlderThanDays = mapped
    }

    /**
     * @param value Level of free space to be maintained by Cloud Tiering if it is enabled.
     */
    @JvmName("pkvwlsdahfjaboxi")
    public suspend fun volumeFreeSpacePercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeFreeSpacePercent = mapped
    }

    internal fun build(): ServerEndpointArgs = ServerEndpointArgs(
        cloudTiering = cloudTiering,
        friendlyName = friendlyName,
        initialDownloadPolicy = initialDownloadPolicy,
        initialUploadPolicy = initialUploadPolicy,
        localCacheMode = localCacheMode,
        offlineDataTransfer = offlineDataTransfer,
        offlineDataTransferShareName = offlineDataTransferShareName,
        resourceGroupName = resourceGroupName,
        serverEndpointName = serverEndpointName,
        serverLocalPath = serverLocalPath,
        serverResourceId = serverResourceId,
        storageSyncServiceName = storageSyncServiceName,
        syncGroupName = syncGroupName,
        tierFilesOlderThanDays = tierFilesOlderThanDays,
        volumeFreeSpacePercent = volumeFreeSpacePercent,
    )
}
