@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Cloud endpoint change enumeration activity object
 * @property deletesProgressPercent Progress percentage for processing deletes. This is done separately from the rest of the enumeration run
 * @property lastUpdatedTimestamp Last updated timestamp
 * @property minutesRemaining Estimate of time remaining for the enumeration run
 * @property operationState Change enumeration operation state
 * @property processedDirectoriesCount Count of directories processed
 * @property processedFilesCount Count of files processed
 * @property progressPercent Progress percentage for change enumeration run, excluding processing of deletes
 * @property startedTimestamp Timestamp when change enumeration started
 * @property statusCode When non-zero, indicates an issue that is delaying change enumeration
 * @property totalCountsState Change enumeration total counts state
 * @property totalDirectoriesCount Total count of directories enumerated
 * @property totalFilesCount Total count of files enumerated
 * @property totalSizeBytes Total enumerated size in bytes
 */
public data class CloudEndpointChangeEnumerationActivityResponse(
    public val deletesProgressPercent: Int,
    public val lastUpdatedTimestamp: String,
    public val minutesRemaining: Int,
    public val operationState: String,
    public val processedDirectoriesCount: Double,
    public val processedFilesCount: Double,
    public val progressPercent: Int,
    public val startedTimestamp: String,
    public val statusCode: Int,
    public val totalCountsState: String,
    public val totalDirectoriesCount: Double,
    public val totalFilesCount: Double,
    public val totalSizeBytes: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudEndpointChangeEnumerationActivityResponse): CloudEndpointChangeEnumerationActivityResponse =
            CloudEndpointChangeEnumerationActivityResponse(
                deletesProgressPercent = javaType.deletesProgressPercent(),
                lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
                minutesRemaining = javaType.minutesRemaining(),
                operationState = javaType.operationState(),
                processedDirectoriesCount = javaType.processedDirectoriesCount(),
                processedFilesCount = javaType.processedFilesCount(),
                progressPercent = javaType.progressPercent(),
                startedTimestamp = javaType.startedTimestamp(),
                statusCode = javaType.statusCode(),
                totalCountsState = javaType.totalCountsState(),
                totalDirectoriesCount = javaType.totalDirectoriesCount(),
                totalFilesCount = javaType.totalFilesCount(),
                totalSizeBytes = javaType.totalSizeBytes(),
            )
    }
}
