@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cloud endpoint change enumeration status object
 * @property activity Change enumeration activity
 * @property lastEnumerationStatus Status of last completed change enumeration
 * @property lastUpdatedTimestamp Last updated timestamp
 */
public data class CloudEndpointChangeEnumerationStatusResponse(
    public val activity: CloudEndpointChangeEnumerationActivityResponse,
    public val lastEnumerationStatus: CloudEndpointLastChangeEnumerationStatusResponse,
    public val lastUpdatedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudEndpointChangeEnumerationStatusResponse): CloudEndpointChangeEnumerationStatusResponse = CloudEndpointChangeEnumerationStatusResponse(
            activity = javaType.activity().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudEndpointChangeEnumerationActivityResponse.Companion.toKotlin(args0)
            }),
            lastEnumerationStatus = javaType.lastEnumerationStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudEndpointLastChangeEnumerationStatusResponse.Companion.toKotlin(args0)
            }),
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
        )
    }
}
