@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Cloud endpoint change enumeration status object
 * @property completedTimestamp Timestamp when change enumeration completed
 * @property namespaceDirectoriesCount Count of directories in the namespace
 * @property namespaceFilesCount Count of files in the namespace
 * @property namespaceSizeBytes Namespace size in bytes
 * @property nextRunTimestamp Timestamp of when change enumeration is expected to run again
 * @property startedTimestamp Timestamp when change enumeration started
 */
public data class CloudEndpointLastChangeEnumerationStatusResponse(
    public val completedTimestamp: String,
    public val namespaceDirectoriesCount: Double,
    public val namespaceFilesCount: Double,
    public val namespaceSizeBytes: Double,
    public val nextRunTimestamp: String,
    public val startedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudEndpointLastChangeEnumerationStatusResponse): CloudEndpointLastChangeEnumerationStatusResponse =
            CloudEndpointLastChangeEnumerationStatusResponse(
                completedTimestamp = javaType.completedTimestamp(),
                namespaceDirectoriesCount = javaType.namespaceDirectoriesCount(),
                namespaceFilesCount = javaType.namespaceFilesCount(),
                namespaceSizeBytes = javaType.namespaceSizeBytes(),
                nextRunTimestamp = javaType.nextRunTimestamp(),
                startedTimestamp = javaType.startedTimestamp(),
            )
    }
}
