@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Server endpoint cloud tiering status object.
 * @property cacheHitBytes Count of bytes that were served from the local server
 * @property cacheHitBytesPercent Percentage of total bytes (hit + miss) that were served from the local server
 * @property cacheMissBytes Count of bytes that were served from the cloud
 * @property lastUpdatedTimestamp Last updated timestamp
 */
public data class CloudTieringCachePerformanceResponse(
    public val cacheHitBytes: Double,
    public val cacheHitBytesPercent: Int,
    public val cacheMissBytes: Double,
    public val lastUpdatedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudTieringCachePerformanceResponse): CloudTieringCachePerformanceResponse = CloudTieringCachePerformanceResponse(
            cacheHitBytes = javaType.cacheHitBytes(),
            cacheHitBytesPercent = javaType.cacheHitBytesPercent(),
            cacheMissBytes = javaType.cacheMissBytes(),
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
        )
    }
}
