@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Status of the date policy
 * @property lastUpdatedTimestamp Last updated timestamp
 * @property tieredFilesMostRecentAccessTimestamp Most recent access time of tiered files
 */
public data class CloudTieringDatePolicyStatusResponse(
    public val lastUpdatedTimestamp: String,
    public val tieredFilesMostRecentAccessTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudTieringDatePolicyStatusResponse): CloudTieringDatePolicyStatusResponse = CloudTieringDatePolicyStatusResponse(
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
            tieredFilesMostRecentAccessTimestamp = javaType.tieredFilesMostRecentAccessTimestamp(),
        )
    }
}
