@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Server endpoint cloud tiering status object.
 * @property errors Array of tiering errors
 * @property lastUpdatedTimestamp Last updated timestamp
 * @property totalFileCount Last cloud tiering result (HResult)
 */
public data class CloudTieringFilesNotTieringResponse(
    public val errors: List<FilesNotTieringErrorResponse>,
    public val lastUpdatedTimestamp: String,
    public val totalFileCount: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.CloudTieringFilesNotTieringResponse): CloudTieringFilesNotTieringResponse = CloudTieringFilesNotTieringResponse(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagesync.kotlin.outputs.FilesNotTieringErrorResponse.Companion.toKotlin(args0)
                })
            }),
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
            totalFileCount = javaType.totalFileCount(),
        )
    }
}
