@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Files not tiering error object
 * @property errorCode Error code (HResult)
 * @property fileCount Count of files with this error
 */
public data class FilesNotTieringErrorResponse(
    public val errorCode: Int,
    public val fileCount: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.FilesNotTieringErrorResponse): FilesNotTieringErrorResponse = FilesNotTieringErrorResponse(
            errorCode = javaType.errorCode(),
            fileCount = javaType.fileCount(),
        )
    }
}
