@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cloud Endpoint object.
 * @property azureFileShareName Azure file share name
 * @property backupEnabled Backup Enabled
 * @property changeEnumerationStatus Cloud endpoint change enumeration status
 * @property friendlyName Friendly Name
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastOperationName Resource Last Operation Name
 * @property lastWorkflowId CloudEndpoint lastWorkflowId
 * @property name The name of the resource
 * @property partnershipId Partnership Id
 * @property provisioningState CloudEndpoint Provisioning State
 * @property storageAccountResourceId Storage Account Resource Id
 * @property storageAccountTenantId Storage Account Tenant Id
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCloudEndpointResult(
    public val azureFileShareName: String? = null,
    public val backupEnabled: String,
    public val changeEnumerationStatus: CloudEndpointChangeEnumerationStatusResponse,
    public val friendlyName: String? = null,
    public val id: String,
    public val lastOperationName: String? = null,
    public val lastWorkflowId: String? = null,
    public val name: String,
    public val partnershipId: String? = null,
    public val provisioningState: String? = null,
    public val storageAccountResourceId: String? = null,
    public val storageAccountTenantId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.GetCloudEndpointResult): GetCloudEndpointResult = GetCloudEndpointResult(
            azureFileShareName = javaType.azureFileShareName().map({ args0 -> args0 }).orElse(null),
            backupEnabled = javaType.backupEnabled(),
            changeEnumerationStatus = javaType.changeEnumerationStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudEndpointChangeEnumerationStatusResponse.Companion.toKotlin(args0)
            }),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastOperationName = javaType.lastOperationName().map({ args0 -> args0 }).orElse(null),
            lastWorkflowId = javaType.lastWorkflowId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            partnershipId = javaType.partnershipId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            storageAccountResourceId = javaType.storageAccountResourceId().map({ args0 -> args0 }).orElse(null),
            storageAccountTenantId = javaType.storageAccountTenantId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
