@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Server Endpoint object.
 * @property cloudTiering Cloud Tiering.
 * @property cloudTieringStatus Cloud tiering status. Only populated if cloud tiering is enabled.
 * @property friendlyName Friendly Name
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property initialDownloadPolicy Policy for how namespace and files are recalled during FastDr.
 * @property initialUploadPolicy Policy for how the initial upload sync session is performed.
 * @property lastOperationName Resource Last Operation Name
 * @property lastWorkflowId ServerEndpoint lastWorkflowId
 * @property localCacheMode Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-populate before local access.
 * @property name The name of the resource
 * @property offlineDataTransfer Offline data transfer
 * @property offlineDataTransferShareName Offline data transfer share name
 * @property offlineDataTransferStorageAccountResourceId Offline data transfer storage account resource ID
 * @property offlineDataTransferStorageAccountTenantId Offline data transfer storage account tenant ID
 * @property provisioningState ServerEndpoint Provisioning State
 * @property recallStatus Recall status. Only populated if cloud tiering is enabled.
 * @property serverLocalPath Server Local path.
 * @property serverName Server name
 * @property serverResourceId Server Resource Id.
 * @property syncStatus Server Endpoint sync status
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tierFilesOlderThanDays Tier files older than days.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property volumeFreeSpacePercent Level of free space to be maintained by Cloud Tiering if it is enabled.
 */
public data class GetServerEndpointResult(
    public val cloudTiering: String? = null,
    public val cloudTieringStatus: ServerEndpointCloudTieringStatusResponse,
    public val friendlyName: String? = null,
    public val id: String,
    public val initialDownloadPolicy: String? = null,
    public val initialUploadPolicy: String? = null,
    public val lastOperationName: String,
    public val lastWorkflowId: String,
    public val localCacheMode: String? = null,
    public val name: String,
    public val offlineDataTransfer: String? = null,
    public val offlineDataTransferShareName: String? = null,
    public val offlineDataTransferStorageAccountResourceId: String,
    public val offlineDataTransferStorageAccountTenantId: String,
    public val provisioningState: String,
    public val recallStatus: ServerEndpointRecallStatusResponse,
    public val serverLocalPath: String? = null,
    public val serverName: String,
    public val serverResourceId: String? = null,
    public val syncStatus: ServerEndpointSyncStatusResponse,
    public val systemData: SystemDataResponse,
    public val tierFilesOlderThanDays: Int? = null,
    public val type: String,
    public val volumeFreeSpacePercent: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.GetServerEndpointResult): GetServerEndpointResult = GetServerEndpointResult(
            cloudTiering = javaType.cloudTiering().map({ args0 -> args0 }).orElse(null),
            cloudTieringStatus = javaType.cloudTieringStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointCloudTieringStatusResponse.Companion.toKotlin(args0)
            }),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            initialDownloadPolicy = javaType.initialDownloadPolicy().map({ args0 -> args0 }).orElse(null),
            initialUploadPolicy = javaType.initialUploadPolicy().map({ args0 -> args0 }).orElse(null),
            lastOperationName = javaType.lastOperationName(),
            lastWorkflowId = javaType.lastWorkflowId(),
            localCacheMode = javaType.localCacheMode().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            offlineDataTransfer = javaType.offlineDataTransfer().map({ args0 -> args0 }).orElse(null),
            offlineDataTransferShareName = javaType.offlineDataTransferShareName().map({ args0 ->
                args0
            }).orElse(null),
            offlineDataTransferStorageAccountResourceId = javaType.offlineDataTransferStorageAccountResourceId(),
            offlineDataTransferStorageAccountTenantId = javaType.offlineDataTransferStorageAccountTenantId(),
            provisioningState = javaType.provisioningState(),
            recallStatus = javaType.recallStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointRecallStatusResponse.Companion.toKotlin(args0)
            }),
            serverLocalPath = javaType.serverLocalPath().map({ args0 -> args0 }).orElse(null),
            serverName = javaType.serverName(),
            serverResourceId = javaType.serverResourceId().map({ args0 -> args0 }).orElse(null),
            syncStatus = javaType.syncStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointSyncStatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tierFilesOlderThanDays = javaType.tierFilesOlderThanDays().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            volumeFreeSpacePercent = javaType.volumeFreeSpacePercent().map({ args0 -> args0 }).orElse(null),
        )
    }
}
