@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Storage Sync Service object.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property incomingTrafficPolicy Incoming Traffic Policy
 * @property lastOperationName Resource Last Operation Name
 * @property lastWorkflowId StorageSyncService lastWorkflowId
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections List of private endpoint connection associated with the specified storage sync service
 * @property provisioningState StorageSyncService Provisioning State
 * @property storageSyncServiceStatus Storage Sync service status.
 * @property storageSyncServiceUid Storage Sync service Uid
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStorageSyncServiceResult(
    public val id: String,
    public val incomingTrafficPolicy: String? = null,
    public val lastOperationName: String,
    public val lastWorkflowId: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val storageSyncServiceStatus: Int,
    public val storageSyncServiceUid: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.GetStorageSyncServiceResult): GetStorageSyncServiceResult = GetStorageSyncServiceResult(
            id = javaType.id(),
            incomingTrafficPolicy = javaType.incomingTrafficPolicy().map({ args0 -> args0 }).orElse(null),
            lastOperationName = javaType.lastOperationName(),
            lastWorkflowId = javaType.lastWorkflowId(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagesync.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            storageSyncServiceStatus = javaType.storageSyncServiceStatus(),
            storageSyncServiceUid = javaType.storageSyncServiceUid(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
