@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Sync Group object.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property syncGroupStatus Sync group status
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property uniqueId Unique Id
 */
public data class GetSyncGroupResult(
    public val id: String,
    public val name: String,
    public val syncGroupStatus: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val uniqueId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.GetSyncGroupResult): GetSyncGroupResult = GetSyncGroupResult(
            id = javaType.id(),
            name = javaType.name(),
            syncGroupStatus = javaType.syncGroupStatus(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            uniqueId = javaType.uniqueId(),
        )
    }
}
