@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Server endpoint cloud tiering status object.
 * @property cachePerformance Information regarding how well the local cache on the server is performing.
 * @property datePolicyStatus Status of the date policy
 * @property filesNotTiering Information regarding files that failed to be tiered
 * @property health Cloud tiering health state.
 * @property healthLastUpdatedTimestamp The last updated timestamp of health state
 * @property lastCloudTieringResult Last cloud tiering result (HResult)
 * @property lastSuccessTimestamp Last cloud tiering success timestamp
 * @property lastUpdatedTimestamp Last updated timestamp
 * @property lowDiskMode Information regarding the low disk mode state
 * @property spaceSavings Information regarding how much local space cloud tiering is saving.
 * @property volumeFreeSpacePolicyStatus Status of the volume free space policy
 */
public data class ServerEndpointCloudTieringStatusResponse(
    public val cachePerformance: CloudTieringCachePerformanceResponse,
    public val datePolicyStatus: CloudTieringDatePolicyStatusResponse,
    public val filesNotTiering: CloudTieringFilesNotTieringResponse,
    public val health: String,
    public val healthLastUpdatedTimestamp: String,
    public val lastCloudTieringResult: Int,
    public val lastSuccessTimestamp: String,
    public val lastUpdatedTimestamp: String,
    public val lowDiskMode: CloudTieringLowDiskModeResponse,
    public val spaceSavings: CloudTieringSpaceSavingsResponse,
    public val volumeFreeSpacePolicyStatus: CloudTieringVolumeFreeSpacePolicyStatusResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.ServerEndpointCloudTieringStatusResponse): ServerEndpointCloudTieringStatusResponse = ServerEndpointCloudTieringStatusResponse(
            cachePerformance = javaType.cachePerformance().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudTieringCachePerformanceResponse.Companion.toKotlin(args0)
            }),
            datePolicyStatus = javaType.datePolicyStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudTieringDatePolicyStatusResponse.Companion.toKotlin(args0)
            }),
            filesNotTiering = javaType.filesNotTiering().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudTieringFilesNotTieringResponse.Companion.toKotlin(args0)
            }),
            health = javaType.health(),
            healthLastUpdatedTimestamp = javaType.healthLastUpdatedTimestamp(),
            lastCloudTieringResult = javaType.lastCloudTieringResult(),
            lastSuccessTimestamp = javaType.lastSuccessTimestamp(),
            lastUpdatedTimestamp = javaType.lastUpdatedTimestamp(),
            lowDiskMode = javaType.lowDiskMode().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudTieringLowDiskModeResponse.Companion.toKotlin(args0)
            }),
            spaceSavings = javaType.spaceSavings().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudTieringSpaceSavingsResponse.Companion.toKotlin(args0)
            }),
            volumeFreeSpacePolicyStatus = javaType.volumeFreeSpacePolicyStatus().let({ args0 ->
                com.pulumi.azurenative.storagesync.kotlin.outputs.CloudTieringVolumeFreeSpacePolicyStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
