@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Files not syncing error object
 * @property errorCode Error code (HResult)
 * @property persistentCount Count of persistent files not syncing with the specified error code
 * @property transientCount Count of transient files not syncing with the specified error code
 */
public data class ServerEndpointFilesNotSyncingErrorResponse(
    public val errorCode: Int,
    public val persistentCount: Double,
    public val transientCount: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.ServerEndpointFilesNotSyncingErrorResponse): ServerEndpointFilesNotSyncingErrorResponse = ServerEndpointFilesNotSyncingErrorResponse(
            errorCode = javaType.errorCode(),
            persistentCount = javaType.persistentCount(),
            transientCount = javaType.transientCount(),
        )
    }
}
