@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Server endpoint recall error object
 * @property count Count of occurences of the error
 * @property errorCode Error code (HResult)
 */
public data class ServerEndpointRecallErrorResponse(
    public val count: Double,
    public val errorCode: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.ServerEndpointRecallErrorResponse): ServerEndpointRecallErrorResponse = ServerEndpointRecallErrorResponse(
            count = javaType.count(),
            errorCode = javaType.errorCode(),
        )
    }
}
