@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Sync Session status object.
 * @property appliedBytes Applied bytes
 * @property appliedItemCount Applied item count.
 * @property perItemErrorCount Per item error count
 * @property sessionMinutesRemaining Session minutes remaining (if available)
 * @property syncMode Sync mode
 * @property timestamp Timestamp when properties were updated
 * @property totalBytes Total bytes (if available)
 * @property totalItemCount Total item count (if available)
 */
public data class ServerEndpointSyncActivityStatusResponse(
    public val appliedBytes: Double,
    public val appliedItemCount: Double,
    public val perItemErrorCount: Double,
    public val sessionMinutesRemaining: Int,
    public val syncMode: String,
    public val timestamp: String,
    public val totalBytes: Double,
    public val totalItemCount: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.ServerEndpointSyncActivityStatusResponse): ServerEndpointSyncActivityStatusResponse = ServerEndpointSyncActivityStatusResponse(
            appliedBytes = javaType.appliedBytes(),
            appliedItemCount = javaType.appliedItemCount(),
            perItemErrorCount = javaType.perItemErrorCount(),
            sessionMinutesRemaining = javaType.sessionMinutesRemaining(),
            syncMode = javaType.syncMode(),
            timestamp = javaType.timestamp(),
            totalBytes = javaType.totalBytes(),
            totalItemCount = javaType.totalItemCount(),
        )
    }
}
