@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagesync.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Sync Session status object.
 * @property filesNotSyncingErrors Array of per-item errors coming from the last sync session.
 * @property lastSyncMode Sync mode
 * @property lastSyncPerItemErrorCount Last sync per item error count.
 * @property lastSyncResult Last sync result (HResult)
 * @property lastSyncSuccessTimestamp Last sync success timestamp
 * @property lastSyncTimestamp Last sync timestamp
 * @property persistentFilesNotSyncingCount Count of persistent files not syncing.
 * @property transientFilesNotSyncingCount Count of transient files not syncing.
 */
public data class ServerEndpointSyncSessionStatusResponse(
    public val filesNotSyncingErrors: List<ServerEndpointFilesNotSyncingErrorResponse>,
    public val lastSyncMode: String,
    public val lastSyncPerItemErrorCount: Double,
    public val lastSyncResult: Int,
    public val lastSyncSuccessTimestamp: String,
    public val lastSyncTimestamp: String,
    public val persistentFilesNotSyncingCount: Double,
    public val transientFilesNotSyncingCount: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagesync.outputs.ServerEndpointSyncSessionStatusResponse): ServerEndpointSyncSessionStatusResponse = ServerEndpointSyncSessionStatusResponse(
            filesNotSyncingErrors = javaType.filesNotSyncingErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagesync.kotlin.outputs.ServerEndpointFilesNotSyncingErrorResponse.Companion.toKotlin(args0)
                })
            }),
            lastSyncMode = javaType.lastSyncMode(),
            lastSyncPerItemErrorCount = javaType.lastSyncPerItemErrorCount(),
            lastSyncResult = javaType.lastSyncResult(),
            lastSyncSuccessTimestamp = javaType.lastSyncSuccessTimestamp(),
            lastSyncTimestamp = javaType.lastSyncTimestamp(),
            persistentFilesNotSyncingCount = javaType.persistentFilesNotSyncingCount(),
            transientFilesNotSyncingCount = javaType.transientFilesNotSyncingCount(),
        )
    }
}
