@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.azurenative.storsimple.BackupScheduleArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.BackupType
import com.pulumi.azurenative.storsimple.kotlin.enums.Kind
import com.pulumi.azurenative.storsimple.kotlin.enums.ScheduleStatus
import com.pulumi.azurenative.storsimple.kotlin.inputs.ScheduleRecurrenceArgs
import com.pulumi.azurenative.storsimple.kotlin.inputs.ScheduleRecurrenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The backup schedule.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### BackupSchedulesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupSchedule = new AzureNative.StorSimple.BackupSchedule("backupSchedule", new()
 *     {
 *         BackupPolicyName = "BkUpPolicy01ForSDKTest",
 *         BackupScheduleName = "schedule2",
 *         BackupType = AzureNative.StorSimple.BackupType.CloudSnapshot,
 *         DeviceName = "Device05ForSDKTest",
 *         Kind = AzureNative.StorSimple.Kind.Series8000,
 *         ManagerName = "ManagerForSDKTest1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         RetentionCount = 1,
 *         ScheduleRecurrence = new AzureNative.StorSimple.Inputs.ScheduleRecurrenceArgs
 *         {
 *             RecurrenceType = AzureNative.StorSimple.RecurrenceType.Weekly,
 *             RecurrenceValue = 1,
 *             WeeklyDaysList = new[]
 *             {
 *                 AzureNative.StorSimple.DayOfWeek.Friday,
 *                 AzureNative.StorSimple.DayOfWeek.Thursday,
 *                 AzureNative.StorSimple.DayOfWeek.Monday,
 *             },
 *         },
 *         ScheduleStatus = AzureNative.StorSimple.ScheduleStatus.Enabled,
 *         StartTime = "2017-06-24T01:00:00Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewBackupSchedule(ctx, "backupSchedule", &storsimple.BackupScheduleArgs{
 * 			BackupPolicyName:   pulumi.String("BkUpPolicy01ForSDKTest"),
 * 			BackupScheduleName: pulumi.String("schedule2"),
 * 			BackupType:         storsimple.BackupTypeCloudSnapshot,
 * 			DeviceName:         pulumi.String("Device05ForSDKTest"),
 * 			Kind:               storsimple.KindSeries8000,
 * 			ManagerName:        pulumi.String("ManagerForSDKTest1"),
 * 			ResourceGroupName:  pulumi.String("ResourceGroupForSDKTest"),
 * 			RetentionCount:     pulumi.Float64(1),
 * 			ScheduleRecurrence: &storsimple.ScheduleRecurrenceArgs{
 * 				RecurrenceType:  storsimple.RecurrenceTypeWeekly,
 * 				RecurrenceValue: pulumi.Int(1),
 * 				WeeklyDaysList: storsimple.DayOfWeekArray{
 * 					storsimple.DayOfWeekFriday,
 * 					storsimple.DayOfWeekThursday,
 * 					storsimple.DayOfWeekMonday,
 * 				},
 * 			},
 * 			ScheduleStatus: storsimple.ScheduleStatusEnabled,
 * 			StartTime:      pulumi.String("2017-06-24T01:00:00Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.BackupSchedule;
 * import com.pulumi.azurenative.storsimple.BackupScheduleArgs;
 * import com.pulumi.azurenative.storsimple.inputs.ScheduleRecurrenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupSchedule = new BackupSchedule("backupSchedule", BackupScheduleArgs.builder()
 *             .backupPolicyName("BkUpPolicy01ForSDKTest")
 *             .backupScheduleName("schedule2")
 *             .backupType("CloudSnapshot")
 *             .deviceName("Device05ForSDKTest")
 *             .kind("Series8000")
 *             .managerName("ManagerForSDKTest1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .retentionCount(1)
 *             .scheduleRecurrence(ScheduleRecurrenceArgs.builder()
 *                 .recurrenceType("Weekly")
 *                 .recurrenceValue(1)
 *                 .weeklyDaysList(
 *                     "Friday",
 *                     "Thursday",
 *                     "Monday")
 *                 .build())
 *             .scheduleStatus("Enabled")
 *             .startTime("2017-06-24T01:00:00Z")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:BackupSchedule schedule2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/backupPolicies/{backupPolicyName}/schedules/{backupScheduleName}
 * ```
 * @property backupPolicyName The backup policy name.
 * @property backupScheduleName The backup schedule name.
 * @property backupType The type of backup which needs to be taken.
 * @property deviceName The device name
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 * @property retentionCount The number of backups to be retained.
 * @property scheduleRecurrence The schedule recurrence.
 * @property scheduleStatus The schedule status.
 * @property startTime The start time of the schedule.
 */
public data class BackupScheduleArgs(
    public val backupPolicyName: Output<String>? = null,
    public val backupScheduleName: Output<String>? = null,
    public val backupType: Output<BackupType>? = null,
    public val deviceName: Output<String>? = null,
    public val kind: Output<Kind>? = null,
    public val managerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionCount: Output<Double>? = null,
    public val scheduleRecurrence: Output<ScheduleRecurrenceArgs>? = null,
    public val scheduleStatus: Output<ScheduleStatus>? = null,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.BackupScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.BackupScheduleArgs =
        com.pulumi.azurenative.storsimple.BackupScheduleArgs.builder()
            .backupPolicyName(backupPolicyName?.applyValue({ args0 -> args0 }))
            .backupScheduleName(backupScheduleName?.applyValue({ args0 -> args0 }))
            .backupType(backupType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .managerName(managerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionCount(retentionCount?.applyValue({ args0 -> args0 }))
            .scheduleRecurrence(
                scheduleRecurrence?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scheduleStatus(scheduleStatus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupScheduleArgs].
 */
@PulumiTagMarker
public class BackupScheduleArgsBuilder internal constructor() {
    private var backupPolicyName: Output<String>? = null

    private var backupScheduleName: Output<String>? = null

    private var backupType: Output<BackupType>? = null

    private var deviceName: Output<String>? = null

    private var kind: Output<Kind>? = null

    private var managerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionCount: Output<Double>? = null

    private var scheduleRecurrence: Output<ScheduleRecurrenceArgs>? = null

    private var scheduleStatus: Output<ScheduleStatus>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value The backup policy name.
     */
    @JvmName("ugpgisdfrpvduyur")
    public suspend fun backupPolicyName(`value`: Output<String>) {
        this.backupPolicyName = value
    }

    /**
     * @param value The backup schedule name.
     */
    @JvmName("fxiftbavxfkrgstw")
    public suspend fun backupScheduleName(`value`: Output<String>) {
        this.backupScheduleName = value
    }

    /**
     * @param value The type of backup which needs to be taken.
     */
    @JvmName("qyaaqbqxapmjrmvo")
    public suspend fun backupType(`value`: Output<BackupType>) {
        this.backupType = value
    }

    /**
     * @param value The device name
     */
    @JvmName("qgtbsfliebrwtjib")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("xwmnplppnuhoyweb")
    public suspend fun kind(`value`: Output<Kind>) {
        this.kind = value
    }

    /**
     * @param value The manager name
     */
    @JvmName("ppyweoqbxckntdal")
    public suspend fun managerName(`value`: Output<String>) {
        this.managerName = value
    }

    /**
     * @param value The resource group name
     */
    @JvmName("mxgghukyxvayfkns")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The number of backups to be retained.
     */
    @JvmName("ppmdmcpfdgvfbxnm")
    public suspend fun retentionCount(`value`: Output<Double>) {
        this.retentionCount = value
    }

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("hxderjytgpfhedfn")
    public suspend fun scheduleRecurrence(`value`: Output<ScheduleRecurrenceArgs>) {
        this.scheduleRecurrence = value
    }

    /**
     * @param value The schedule status.
     */
    @JvmName("jwkcwuupvqasfkot")
    public suspend fun scheduleStatus(`value`: Output<ScheduleStatus>) {
        this.scheduleStatus = value
    }

    /**
     * @param value The start time of the schedule.
     */
    @JvmName("wbawyjceutcrnenr")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The backup policy name.
     */
    @JvmName("fwihnwrciwmwiwrg")
    public suspend fun backupPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPolicyName = mapped
    }

    /**
     * @param value The backup schedule name.
     */
    @JvmName("mhlsxpetrdxdeylt")
    public suspend fun backupScheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupScheduleName = mapped
    }

    /**
     * @param value The type of backup which needs to be taken.
     */
    @JvmName("xtnythlqtwaftipw")
    public suspend fun backupType(`value`: BackupType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value The device name
     */
    @JvmName("cpbtgwlkgqtaakvu")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The Kind of the object. Currently only Series8000 is supported
     */
    @JvmName("mmsiqwmvtqatsgcp")
    public suspend fun kind(`value`: Kind?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("ocnawvxwijxjdtxx")
    public suspend fun managerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("cqchpajoncsupscm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The number of backups to be retained.
     */
    @JvmName("nkhtxkbifarmpbbm")
    public suspend fun retentionCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionCount = mapped
    }

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("dtwswkvhanrftvmf")
    public suspend fun scheduleRecurrence(`value`: ScheduleRecurrenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleRecurrence = mapped
    }

    /**
     * @param argument The schedule recurrence.
     */
    @JvmName("yrodbettxhxpvlja")
    public suspend fun scheduleRecurrence(argument: suspend ScheduleRecurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleRecurrenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduleRecurrence = mapped
    }

    /**
     * @param value The schedule status.
     */
    @JvmName("tnubftceflbfnbgo")
    public suspend fun scheduleStatus(`value`: ScheduleStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleStatus = mapped
    }

    /**
     * @param value The start time of the schedule.
     */
    @JvmName("hinqobmieddjchap")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): BackupScheduleArgs = BackupScheduleArgs(
        backupPolicyName = backupPolicyName,
        backupScheduleName = backupScheduleName,
        backupType = backupType,
        deviceName = deviceName,
        kind = kind,
        managerName = managerName,
        resourceGroupName = resourceGroupName,
        retentionCount = retentionCount,
        scheduleRecurrence = scheduleRecurrence,
        scheduleStatus = scheduleStatus,
        startTime = startTime,
    )
}
