@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagerExtendedInfo].
 */
@PulumiTagMarker
public class ManagerExtendedInfoResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagerExtendedInfoArgs = ManagerExtendedInfoArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagerExtendedInfoArgsBuilder.() -> Unit) {
        val builder = ManagerExtendedInfoArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagerExtendedInfo {
        val builtJavaResource =
            com.pulumi.azurenative.storsimple.ManagerExtendedInfo(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagerExtendedInfo(builtJavaResource)
    }
}

/**
 * The extended info of the manager.
 * Azure REST API version: 2017-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * ## Example Usage
 * ### ManagersCreateExtendedInfo
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managerExtendedInfo = new AzureNative.StorSimple.ManagerExtendedInfo("managerExtendedInfo", new()
 *     {
 *         Algorithm = "None",
 *         IntegrityKey = "BIl+RHqO8PZ6DRvuXTTK7g==",
 *         ManagerName = "ManagerForSDKTest2",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storsimple/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storsimple.NewManagerExtendedInfo(ctx, "managerExtendedInfo", &storsimple.ManagerExtendedInfoArgs{
 * 			Algorithm:         pulumi.String("None"),
 * 			IntegrityKey:      pulumi.String("BIl+RHqO8PZ6DRvuXTTK7g=="),
 * 			ManagerName:       pulumi.String("ManagerForSDKTest2"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storsimple.ManagerExtendedInfo;
 * import com.pulumi.azurenative.storsimple.ManagerExtendedInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managerExtendedInfo = new ManagerExtendedInfo("managerExtendedInfo", ManagerExtendedInfoArgs.builder()
 *             .algorithm("None")
 *             .integrityKey("BIl+RHqO8PZ6DRvuXTTK7g==")
 *             .managerName("ManagerForSDKTest2")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storsimple:ManagerExtendedInfo vaultExtendedInfo /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo
 * ```
 */
public class ManagerExtendedInfo internal constructor(
    override val javaResource: com.pulumi.azurenative.storsimple.ManagerExtendedInfo,
) : KotlinCustomResource(javaResource, ManagerExtendedInfoMapper) {
    /**
     * Represents the encryption algorithm used to encrypt the keys. None - if Key is saved in plain text format. Algorithm name - if key is encrypted
     */
    public val algorithm: Output<String>
        get() = javaResource.algorithm().applyValue({ args0 -> args0 })

    /**
     * Represents the CEK of the resource.
     */
    public val encryptionKey: Output<String>?
        get() = javaResource.encryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Represents the Cert thumbprint that was used to encrypt the CEK.
     */
    public val encryptionKeyThumbprint: Output<String>?
        get() = javaResource.encryptionKeyThumbprint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The etag of the resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Represents the CIK of the resource.
     */
    public val integrityKey: Output<String>
        get() = javaResource.integrityKey().applyValue({ args0 -> args0 })

    /**
     * The Kind of the object. Currently only Series8000 is supported
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
     */
    public val portalCertificateThumbprint: Output<String>?
        get() = javaResource.portalCertificateThumbprint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The hierarchical type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The version of the extended info being persisted.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ManagerExtendedInfoMapper : ResourceMapper<ManagerExtendedInfo> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storsimple.ManagerExtendedInfo::class == javaResource::class

    override fun map(javaResource: Resource): ManagerExtendedInfo = ManagerExtendedInfo(
        javaResource
            as com.pulumi.azurenative.storsimple.ManagerExtendedInfo,
    )
}

/**
 * @see [ManagerExtendedInfo].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagerExtendedInfo].
 */
public suspend fun managerExtendedInfo(
    name: String,
    block: suspend ManagerExtendedInfoResourceBuilder.() -> Unit,
): ManagerExtendedInfo {
    val builder = ManagerExtendedInfoResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagerExtendedInfo].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managerExtendedInfo(name: String): ManagerExtendedInfo {
    val builder = ManagerExtendedInfoResourceBuilder()
    builder.name(name)
    return builder.build()
}
