@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.AsymmetricEncryptedSecretArgs.builder
import com.pulumi.azurenative.storsimple.kotlin.enums.EncryptionAlgorithm
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represent the secrets intended for encryption with asymmetric key pair.
 * @property encryptionAlgorithm The algorithm used to encrypt "Value".
 * @property encryptionCertThumbprint Thumbprint certificate that was used to encrypt "Value". If the value in unencrypted, it will be null.
 * @property value The value of the secret.
 */
public data class AsymmetricEncryptedSecretArgs(
    public val encryptionAlgorithm: Output<EncryptionAlgorithm>,
    public val encryptionCertThumbprint: Output<String>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.AsymmetricEncryptedSecretArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.AsymmetricEncryptedSecretArgs =
        com.pulumi.azurenative.storsimple.inputs.AsymmetricEncryptedSecretArgs.builder()
            .encryptionAlgorithm(
                encryptionAlgorithm.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .encryptionCertThumbprint(encryptionCertThumbprint?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AsymmetricEncryptedSecretArgs].
 */
@PulumiTagMarker
public class AsymmetricEncryptedSecretArgsBuilder internal constructor() {
    private var encryptionAlgorithm: Output<EncryptionAlgorithm>? = null

    private var encryptionCertThumbprint: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The algorithm used to encrypt "Value".
     */
    @JvmName("wgvkhqspqiuknisc")
    public suspend fun encryptionAlgorithm(`value`: Output<EncryptionAlgorithm>) {
        this.encryptionAlgorithm = value
    }

    /**
     * @param value Thumbprint certificate that was used to encrypt "Value". If the value in unencrypted, it will be null.
     */
    @JvmName("gouwdefpckjuuwow")
    public suspend fun encryptionCertThumbprint(`value`: Output<String>) {
        this.encryptionCertThumbprint = value
    }

    /**
     * @param value The value of the secret.
     */
    @JvmName("dertjsijwcsddgvg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The algorithm used to encrypt "Value".
     */
    @JvmName("whqjjckoqtxkedmy")
    public suspend fun encryptionAlgorithm(`value`: EncryptionAlgorithm) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value Thumbprint certificate that was used to encrypt "Value". If the value in unencrypted, it will be null.
     */
    @JvmName("ljqcllyiiegywxqx")
    public suspend fun encryptionCertThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionCertThumbprint = mapped
    }

    /**
     * @param value The value of the secret.
     */
    @JvmName("rfelmjsccbaaqeld")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AsymmetricEncryptedSecretArgs = AsymmetricEncryptedSecretArgs(
        encryptionAlgorithm = encryptionAlgorithm ?: throw PulumiNullFieldException("encryptionAlgorithm"),
        encryptionCertThumbprint = encryptionCertThumbprint,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
