@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.GetManagerDevicePublicEncryptionKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The device name
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 */
public data class GetManagerDevicePublicEncryptionKeyPlainArgs(
    public val deviceName: String,
    public val managerName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.GetManagerDevicePublicEncryptionKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.GetManagerDevicePublicEncryptionKeyPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.GetManagerDevicePublicEncryptionKeyPlainArgs.builder()
            .deviceName(deviceName.let({ args0 -> args0 }))
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagerDevicePublicEncryptionKeyPlainArgs].
 */
@PulumiTagMarker
public class GetManagerDevicePublicEncryptionKeyPlainArgsBuilder internal constructor() {
    private var deviceName: String? = null

    private var managerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The device name
     */
    @JvmName("svmleohpwststlot")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value The manager name
     */
    @JvmName("aqavtjhvpygjwufa")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("xuiaijvsetjwtolv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagerDevicePublicEncryptionKeyPlainArgs =
        GetManagerDevicePublicEncryptionKeyPlainArgs(
            deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
            managerName = managerName ?: throw PulumiNullFieldException("managerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
