@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.inputs

import com.pulumi.azurenative.storsimple.inputs.ListManagerPublicEncryptionKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managerName The manager name
 * @property resourceGroupName The resource group name
 */
public data class ListManagerPublicEncryptionKeyPlainArgs(
    public val managerName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.storsimple.inputs.ListManagerPublicEncryptionKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storsimple.inputs.ListManagerPublicEncryptionKeyPlainArgs =
        com.pulumi.azurenative.storsimple.inputs.ListManagerPublicEncryptionKeyPlainArgs.builder()
            .managerName(managerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListManagerPublicEncryptionKeyPlainArgs].
 */
@PulumiTagMarker
public class ListManagerPublicEncryptionKeyPlainArgsBuilder internal constructor() {
    private var managerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The manager name
     */
    @JvmName("jgblepcpmeybvugh")
    public suspend fun managerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managerName = mapped
    }

    /**
     * @param value The resource group name
     */
    @JvmName("amphxeapxcoejcjp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListManagerPublicEncryptionKeyPlainArgs =
        ListManagerPublicEncryptionKeyPlainArgs(
            managerName = managerName ?: throw PulumiNullFieldException("managerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
