@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The schedule for bandwidth setting.
 * @property days The days of the week when this schedule is applicable.
 * @property rateInMbps The rate in Mbps.
 * @property start The start time of the schedule.
 * @property stop The stop time of the schedule.
 */
public data class BandwidthScheduleResponse(
    public val days: List<String>,
    public val rateInMbps: Int,
    public val start: TimeResponse,
    public val stop: TimeResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.BandwidthScheduleResponse): BandwidthScheduleResponse = BandwidthScheduleResponse(
            days = javaType.days().map({ args0 -> args0 }),
            rateInMbps = javaType.rateInMbps(),
            start = javaType.start().let({ args0 ->
                com.pulumi.azurenative.storsimple.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
            }),
            stop = javaType.stop().let({ args0 ->
                com.pulumi.azurenative.storsimple.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
