@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The access control record.
 * @property id The path ID that uniquely identifies the object.
 * @property initiatorName The iSCSI initiator name (IQN).
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property name The name of the object.
 * @property type The hierarchical type of the object.
 * @property volumeCount The number of volumes using the access control record.
 */
public data class GetAccessControlRecordResult(
    public val id: String,
    public val initiatorName: String,
    public val kind: String? = null,
    public val name: String,
    public val type: String,
    public val volumeCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetAccessControlRecordResult): GetAccessControlRecordResult = GetAccessControlRecordResult(
            id = javaType.id(),
            initiatorName = javaType.initiatorName(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
            volumeCount = javaType.volumeCount(),
        )
    }
}
