@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The backup schedule.
 * @property backupType The type of backup which needs to be taken.
 * @property id The path ID that uniquely identifies the object.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property lastSuccessfulRun The last successful backup run which was triggered for the schedule.
 * @property name The name of the object.
 * @property retentionCount The number of backups to be retained.
 * @property scheduleRecurrence The schedule recurrence.
 * @property scheduleStatus The schedule status.
 * @property startTime The start time of the schedule.
 * @property type The hierarchical type of the object.
 */
public data class GetBackupScheduleResult(
    public val backupType: String,
    public val id: String,
    public val kind: String? = null,
    public val lastSuccessfulRun: String,
    public val name: String,
    public val retentionCount: Double,
    public val scheduleRecurrence: ScheduleRecurrenceResponse,
    public val scheduleStatus: String,
    public val startTime: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetBackupScheduleResult): GetBackupScheduleResult = GetBackupScheduleResult(
            backupType = javaType.backupType(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            lastSuccessfulRun = javaType.lastSuccessfulRun(),
            name = javaType.name(),
            retentionCount = javaType.retentionCount(),
            scheduleRecurrence = javaType.scheduleRecurrence().let({ args0 ->
                com.pulumi.azurenative.storsimple.kotlin.outputs.ScheduleRecurrenceResponse.Companion.toKotlin(args0)
            }),
            scheduleStatus = javaType.scheduleStatus(),
            startTime = javaType.startTime(),
            type = javaType.type(),
        )
    }
}
