@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The extended info of the manager.
 * @property algorithm Represents the encryption algorithm used to encrypt the keys. None - if Key is saved in plain text format. Algorithm name - if key is encrypted
 * @property encryptionKey Represents the CEK of the resource.
 * @property encryptionKeyThumbprint Represents the Cert thumbprint that was used to encrypt the CEK.
 * @property etag The etag of the resource.
 * @property id The path ID that uniquely identifies the object.
 * @property integrityKey Represents the CIK of the resource.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property name The name of the object.
 * @property portalCertificateThumbprint Represents the portal thumbprint which can be used optionally to encrypt the entire data before storing it.
 * @property type The hierarchical type of the object.
 * @property version The version of the extended info being persisted.
 */
public data class GetManagerExtendedInfoResult(
    public val algorithm: String,
    public val encryptionKey: String? = null,
    public val encryptionKeyThumbprint: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val integrityKey: String,
    public val kind: String? = null,
    public val name: String,
    public val portalCertificateThumbprint: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetManagerExtendedInfoResult): GetManagerExtendedInfoResult = GetManagerExtendedInfoResult(
            algorithm = javaType.algorithm(),
            encryptionKey = javaType.encryptionKey().map({ args0 -> args0 }).orElse(null),
            encryptionKeyThumbprint = javaType.encryptionKeyThumbprint().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            integrityKey = javaType.integrityKey(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            portalCertificateThumbprint = javaType.portalCertificateThumbprint().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
