@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The StorSimple Manager.
 * @property cisIntrinsicSettings Represents the type of StorSimple Manager.
 * @property etag The etag of the manager.
 * @property id The resource ID.
 * @property location The geo location of the resource.
 * @property name The resource name.
 * @property provisioningState Specifies the state of the resource as it is getting provisioned. Value of "Succeeded" means the Manager was successfully created.
 * @property sku Specifies the Sku.
 * @property tags The tags attached to the resource.
 * @property type The resource type.
 */
public data class GetManagerResult(
    public val cisIntrinsicSettings: ManagerIntrinsicSettingsResponse? = null,
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String? = null,
    public val sku: ManagerSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetManagerResult): GetManagerResult = GetManagerResult(
            cisIntrinsicSettings = javaType.cisIntrinsicSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.ManagerIntrinsicSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.ManagerSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
