@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The storage account credential.
 * @property accessKey The details of the storage account password.
 * @property endPoint The storage endpoint
 * @property id The path ID that uniquely identifies the object.
 * @property kind The Kind of the object. Currently only Series8000 is supported
 * @property name The name of the object.
 * @property sslStatus Signifies whether SSL needs to be enabled or not.
 * @property type The hierarchical type of the object.
 * @property volumesCount The count of volumes using this storage account credential.
 */
public data class GetStorageAccountCredentialResult(
    public val accessKey: AsymmetricEncryptedSecretResponse? = null,
    public val endPoint: String,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val sslStatus: String,
    public val type: String,
    public val volumesCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.GetStorageAccountCredentialResult): GetStorageAccountCredentialResult = GetStorageAccountCredentialResult(
            accessKey = javaType.accessKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storsimple.kotlin.outputs.AsymmetricEncryptedSecretResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endPoint = javaType.endPoint(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            sslStatus = javaType.sslStatus(),
            type = javaType.type(),
            volumesCount = javaType.volumesCount(),
        )
    }
}
