@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents the secrets encrypted using Symmetric Encryption Key.
 * @property encryptionAlgorithm The algorithm used to encrypt the "Value".
 * @property value The value of the secret itself. If the secret is in plaintext or null then EncryptionAlgorithm will be none.
 * @property valueCertificateThumbprint The thumbprint of the cert that was used to encrypt "Value".
 */
public data class ListManagerPublicEncryptionKeyResult(
    public val encryptionAlgorithm: String,
    public val `value`: String,
    public val valueCertificateThumbprint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.ListManagerPublicEncryptionKeyResult): ListManagerPublicEncryptionKeyResult = ListManagerPublicEncryptionKeyResult(
            encryptionAlgorithm = javaType.encryptionAlgorithm(),
            `value` = javaType.`value`(),
            valueCertificateThumbprint = javaType.valueCertificateThumbprint().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
