@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storsimple.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The error/warning message due to which the device is ineligible as a failover target device.
 * @property message The localized error message stating the reason why the device is not eligible as a target device.
 * @property resolution The localized resolution message for the error.
 * @property resultCode The result code for the error, due to which the device does not qualify as a failover target device.
 */
public data class TargetEligibilityErrorMessageResponse(
    public val message: String? = null,
    public val resolution: String? = null,
    public val resultCode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storsimple.outputs.TargetEligibilityErrorMessageResponse): TargetEligibilityErrorMessageResponse = TargetEligibilityErrorMessageResponse(
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            resolution = javaType.resolution().map({ args0 -> args0 }).orElse(null),
            resultCode = javaType.resultCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
