@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.kotlin.outputs.AggregateFunctionPropertiesResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.ScalarFunctionPropertiesResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Function].
 */
@PulumiTagMarker
public class FunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FunctionArgs = FunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FunctionArgsBuilder.() -> Unit) {
        val builder = FunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Function {
        val builtJavaResource = com.pulumi.azurenative.streamanalytics.Function(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Function(builtJavaResource)
    }
}

/**
 * A function object, containing all information associated with the named function. All functions are contained under a streaming job.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * Other available API versions: 2016-03-01, 2021-10-01-preview.
 * ## Example Usage
 * ### Create a JavaScript function
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var function = new AzureNative.StreamAnalytics.Function("function", new()
 *     {
 *         FunctionName = "function8197",
 *         JobName = "sj8653",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.ScalarFunctionPropertiesArgs
 *         {
 *             Binding = new AzureNative.StreamAnalytics.Inputs.JavaScriptFunctionBindingArgs
 *             {
 *                 Script = "function (x, y) { return x + y; }",
 *                 Type = "Microsoft.StreamAnalytics/JavascriptUdf",
 *             },
 *             Inputs = new[]
 *             {
 *                 new AzureNative.StreamAnalytics.Inputs.FunctionInputArgs
 *                 {
 *                     DataType = "Any",
 *                 },
 *             },
 *             Output = new AzureNative.StreamAnalytics.Inputs.FunctionOutputArgs
 *             {
 *                 DataType = "Any",
 *             },
 *             Type = "Scalar",
 *         },
 *         ResourceGroupName = "sjrg1637",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewFunction(ctx, "function", &streamanalytics.FunctionArgs{
 * 			FunctionName: pulumi.String("function8197"),
 * 			JobName:      pulumi.String("sj8653"),
 * 			Properties: streamanalytics.ScalarFunctionProperties{
 * 				Binding: streamanalytics.JavaScriptFunctionBinding{
 * 					Script: "function (x, y) { return x + y; }",
 * 					Type:   "Microsoft.StreamAnalytics/JavascriptUdf",
 * 				},
 * 				Inputs: []streamanalytics.FunctionInputType{
 * 					{
 * 						DataType: "Any",
 * 					},
 * 				},
 * 				Output: streamanalytics.FunctionOutputType{
 * 					DataType: "Any",
 * 				},
 * 				Type: "Scalar",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg1637"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Function;
 * import com.pulumi.azurenative.streamanalytics.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var function = new Function("function", FunctionArgs.builder()
 *             .functionName("function8197")
 *             .jobName("sj8653")
 *             .properties(ScalarFunctionPropertiesArgs.builder()
 *                 .binding(AzureMachineLearningWebServiceFunctionBindingArgs.builder()
 *                     .script("function (x, y) { return x + y; }")
 *                     .type("Microsoft.StreamAnalytics/JavascriptUdf")
 *                     .build())
 *                 .inputs(FunctionInputArgs.builder()
 *                     .dataType("Any")
 *                     .build())
 *                 .output(FunctionOutputArgs.builder()
 *                     .dataType("Any")
 *                     .build())
 *                 .type("Scalar")
 *                 .build())
 *             .resourceGroupName("sjrg1637")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Azure ML function
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var function = new AzureNative.StreamAnalytics.Function("function", new()
 *     {
 *         FunctionName = "function588",
 *         JobName = "sj9093",
 *         Properties = new AzureNative.StreamAnalytics.Inputs.ScalarFunctionPropertiesArgs
 *         {
 *             Binding = new AzureNative.StreamAnalytics.Inputs.AzureMachineLearningWebServiceFunctionBindingArgs
 *             {
 *                 ApiKey = "someApiKey==",
 *                 BatchSize = 1000,
 *                 Endpoint = "someAzureMLEndpointURL",
 *                 Inputs = new AzureNative.StreamAnalytics.Inputs.AzureMachineLearningWebServiceInputsArgs
 *                 {
 *                     ColumnNames = new[]
 *                     {
 *                         new AzureNative.StreamAnalytics.Inputs.AzureMachineLearningWebServiceInputColumnArgs
 *                         {
 *                             DataType = "string",
 *                             MapTo = 0,
 *                             Name = "tweet",
 *                         },
 *                     },
 *                     Name = "input1",
 *                 },
 *                 Outputs = new[]
 *                 {
 *                     new AzureNative.StreamAnalytics.Inputs.AzureMachineLearningWebServiceOutputColumnArgs
 *                     {
 *                         DataType = "string",
 *                         Name = "Sentiment",
 *                     },
 *                 },
 *                 Type = "Microsoft.MachineLearning/WebService",
 *             },
 *             Inputs = new[]
 *             {
 *                 new AzureNative.StreamAnalytics.Inputs.FunctionInputArgs
 *                 {
 *                     DataType = "nvarchar(max)",
 *                 },
 *             },
 *             Output = new AzureNative.StreamAnalytics.Inputs.FunctionOutputArgs
 *             {
 *                 DataType = "nvarchar(max)",
 *             },
 *             Type = "Scalar",
 *         },
 *         ResourceGroupName = "sjrg7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewFunction(ctx, "function", &streamanalytics.FunctionArgs{
 * 			FunctionName: pulumi.String("function588"),
 * 			JobName:      pulumi.String("sj9093"),
 * 			Properties: streamanalytics.ScalarFunctionProperties{
 * 				Binding: streamanalytics.AzureMachineLearningWebServiceFunctionBinding{
 * 					ApiKey:    "someApiKey==",
 * 					BatchSize: 1000,
 * 					Endpoint:  "someAzureMLEndpointURL",
 * 					Inputs: streamanalytics.AzureMachineLearningWebServiceInputs{
 * 						ColumnNames: []streamanalytics.AzureMachineLearningWebServiceInputColumn{
 * 							{
 * 								DataType: "string",
 * 								MapTo:    0,
 * 								Name:     "tweet",
 * 							},
 * 						},
 * 						Name: "input1",
 * 					},
 * 					Outputs: []streamanalytics.AzureMachineLearningWebServiceOutputColumn{
 * 						{
 * 							DataType: "string",
 * 							Name:     "Sentiment",
 * 						},
 * 					},
 * 					Type: "Microsoft.MachineLearning/WebService",
 * 				},
 * 				Inputs: []streamanalytics.FunctionInputType{
 * 					{
 * 						DataType: "nvarchar(max)",
 * 					},
 * 				},
 * 				Output: streamanalytics.FunctionOutputType{
 * 					DataType: "nvarchar(max)",
 * 				},
 * 				Type: "Scalar",
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.Function;
 * import com.pulumi.azurenative.streamanalytics.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var function = new Function("function", FunctionArgs.builder()
 *             .functionName("function588")
 *             .jobName("sj9093")
 *             .properties(ScalarFunctionPropertiesArgs.builder()
 *                 .binding(AzureMachineLearningWebServiceFunctionBindingArgs.builder()
 *                     .apiKey("someApiKey==")
 *                     .batchSize(1000)
 *                     .endpoint("someAzureMLEndpointURL")
 *                     .inputs(AzureMachineLearningWebServiceInputsArgs.builder()
 *                         .columnNames(AzureMachineLearningWebServiceInputColumnArgs.builder()
 *                             .dataType("string")
 *                             .mapTo(0)
 *                             .name("tweet")
 *                             .build())
 *                         .name("input1")
 *                         .build())
 *                     .outputs(AzureMachineLearningWebServiceOutputColumnArgs.builder()
 *                         .dataType("string")
 *                         .name("Sentiment")
 *                         .build())
 *                     .type("Microsoft.MachineLearning/WebService")
 *                     .build())
 *                 .inputs(FunctionInputArgs.builder()
 *                     .dataType("nvarchar(max)")
 *                     .build())
 *                 .output(FunctionOutputArgs.builder()
 *                     .dataType("nvarchar(max)")
 *                     .build())
 *                 .type("Scalar")
 *                 .build())
 *             .resourceGroupName("sjrg7")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:Function function588 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}
 * ```
 */
public class Function internal constructor(
    override val javaResource: com.pulumi.azurenative.streamanalytics.Function,
) : KotlinCustomResource(javaResource, FunctionMapper) {
    /**
     * Resource name
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The properties that are associated with a function.
     */
    public val properties:
        Output<Either<AggregateFunctionPropertiesResponse, ScalarFunctionPropertiesResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.streamanalytics.kotlin.outputs.AggregateFunctionPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.streamanalytics.kotlin.outputs.ScalarFunctionPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FunctionMapper : ResourceMapper<Function> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.streamanalytics.Function::class == javaResource::class

    override fun map(javaResource: Resource): Function = Function(
        javaResource as
            com.pulumi.azurenative.streamanalytics.Function,
    )
}

/**
 * @see [Function].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Function].
 */
public suspend fun function(name: String, block: suspend FunctionResourceBuilder.() -> Unit): Function {
    val builder = FunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Function].
 * @param name The _unique_ name of the resulting resource.
 */
public fun function(name: String): Function {
    val builder = FunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
