@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin

import com.pulumi.azurenative.streamanalytics.kotlin.outputs.ClusterInfoResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.FunctionResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.InputResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.JobStorageAccountResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.OutputResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.TransformationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.ClusterInfoResponse.Companion.toKotlin as clusterInfoResponseToKotlin
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.FunctionResponse.Companion.toKotlin as functionResponseToKotlin
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.InputResponse.Companion.toKotlin as inputResponseToKotlin
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.JobStorageAccountResponse.Companion.toKotlin as jobStorageAccountResponseToKotlin
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.OutputResponse.Companion.toKotlin as outputResponseToKotlin
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.streamanalytics.kotlin.outputs.TransformationResponse.Companion.toKotlin as transformationResponseToKotlin

/**
 * Builder for [StreamingJob].
 */
@PulumiTagMarker
public class StreamingJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StreamingJobArgs = StreamingJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StreamingJobArgsBuilder.() -> Unit) {
        val builder = StreamingJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StreamingJob {
        val builtJavaResource =
            com.pulumi.azurenative.streamanalytics.StreamingJob(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StreamingJob(builtJavaResource)
    }
}

/**
 * A streaming job object, containing all information associated with the named streaming job.
 * Azure REST API version: 2020-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * Other available API versions: 2017-04-01-preview, 2021-10-01-preview.
 * ## Example Usage
 * ### Create a complete streaming job (a streaming job with a transformation, at least 1 input and at least 1 output)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingJob = new AzureNative.StreamAnalytics.StreamingJob("streamingJob", new()
 *     {
 *         CompatibilityLevel = AzureNative.StreamAnalytics.CompatibilityLevel.CompatibilityLevel_1_0,
 *         DataLocale = "en-US",
 *         EventsLateArrivalMaxDelayInSeconds = 5,
 *         EventsOutOfOrderMaxDelayInSeconds = 0,
 *         EventsOutOfOrderPolicy = AzureNative.StreamAnalytics.EventsOutOfOrderPolicy.Drop,
 *         Functions = new[] {},
 *         Inputs = new[]
 *         {
 *             new AzureNative.StreamAnalytics.Inputs.InputArgs
 *             {
 *                 Name = "inputtest",
 *                 Properties = new AzureNative.StreamAnalytics.Inputs.StreamInputPropertiesArgs
 *                 {
 *                     Datasource = new AzureNative.StreamAnalytics.Inputs.BlobStreamInputDataSourceArgs
 *                     {
 *                         Container = "containerName",
 *                         PathPattern = "",
 *                         StorageAccounts = new[]
 *                         {
 *                             new AzureNative.StreamAnalytics.Inputs.StorageAccountArgs
 *                             {
 *                                 AccountKey = "yourAccountKey==",
 *                                 AccountName = "yourAccountName",
 *                             },
 *                         },
 *                         Type = "Microsoft.Storage/Blob",
 *                     },
 *                     Serialization = new AzureNative.StreamAnalytics.Inputs.JsonSerializationArgs
 *                     {
 *                         Encoding = AzureNative.StreamAnalytics.Encoding.UTF8,
 *                         Type = "Json",
 *                     },
 *                     Type = "Stream",
 *                 },
 *             },
 *         },
 *         JobName = "sj7804",
 *         Location = "West US",
 *         OutputErrorPolicy = AzureNative.StreamAnalytics.OutputErrorPolicy.Drop,
 *         Outputs = new[]
 *         {
 *             new AzureNative.StreamAnalytics.Inputs.OutputArgs
 *             {
 *                 Datasource = new AzureNative.StreamAnalytics.Inputs.AzureSqlDatabaseOutputDataSourceArgs
 *                 {
 *                     Database = "databaseName",
 *                     Password = "userPassword",
 *                     Server = "serverName",
 *                     Table = "tableName",
 *                     Type = "Microsoft.Sql/Server/Database",
 *                     User = "<user>",
 *                 },
 *                 Name = "outputtest",
 *             },
 *         },
 *         ResourceGroupName = "sjrg3276",
 *         Sku = new AzureNative.StreamAnalytics.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.StreamAnalytics.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key3", "value3" },
 *             { "randomKey", "randomValue" },
 *         },
 *         Transformation = new AzureNative.StreamAnalytics.Inputs.TransformationArgs
 *         {
 *             Name = "transformationtest",
 *             Query = "Select Id, Name from inputtest",
 *             StreamingUnits = 1,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewStreamingJob(ctx, "streamingJob", &streamanalytics.StreamingJobArgs{
 * 			CompatibilityLevel:                 pulumi.String(streamanalytics.CompatibilityLevel_1_0),
 * 			DataLocale:                         pulumi.String("en-US"),
 * 			EventsLateArrivalMaxDelayInSeconds: pulumi.Int(5),
 * 			EventsOutOfOrderMaxDelayInSeconds:  pulumi.Int(0),
 * 			EventsOutOfOrderPolicy:             pulumi.String(streamanalytics.EventsOutOfOrderPolicyDrop),
 * 			Functions:                          streamanalytics.FunctionTypeArray{},
 * 			Inputs: streamanalytics.InputTypeArray{
 * 				&streamanalytics.InputTypeArgs{
 * 					Name: pulumi.String("inputtest"),
 * 					Properties: streamanalytics.StreamInputProperties{
 * 						Datasource: streamanalytics.BlobStreamInputDataSource{
 * 							Container:   "containerName",
 * 							PathPattern: "",
 * 							StorageAccounts: []streamanalytics.StorageAccount{
 * 								{
 * 									AccountKey:  "yourAccountKey==",
 * 									AccountName: "yourAccountName",
 * 								},
 * 							},
 * 							Type: "Microsoft.Storage/Blob",
 * 						},
 * 						Serialization: streamanalytics.JsonSerialization{
 * 							Encoding: streamanalytics.EncodingUTF8,
 * 							Type:     "Json",
 * 						},
 * 						Type: "Stream",
 * 					},
 * 				},
 * 			},
 * 			JobName:           pulumi.String("sj7804"),
 * 			Location:          pulumi.String("West US"),
 * 			OutputErrorPolicy: pulumi.String(streamanalytics.OutputErrorPolicyDrop),
 * 			Outputs: streamanalytics.OutputTypeArray{
 * 				&streamanalytics.OutputTypeArgs{
 * 					Datasource: streamanalytics.AzureSqlDatabaseOutputDataSource{
 * 						Database: "databaseName",
 * 						Password: "userPassword",
 * 						Server:   "serverName",
 * 						Table:    "tableName",
 * 						Type:     "Microsoft.Sql/Server/Database",
 * 						User:     "<user>",
 * 					},
 * 					Name: pulumi.String("outputtest"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("sjrg3276"),
 * 			Sku: &streamanalytics.SkuArgs{
 * 				Name: pulumi.String(streamanalytics.SkuNameStandard),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1":      pulumi.String("value1"),
 * 				"key3":      pulumi.String("value3"),
 * 				"randomKey": pulumi.String("randomValue"),
 * 			},
 * 			Transformation: &streamanalytics.TransformationArgs{
 * 				Name:           pulumi.String("transformationtest"),
 * 				Query:          pulumi.String("Select Id, Name from inputtest"),
 * 				StreamingUnits: pulumi.Int(1),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.StreamingJob;
 * import com.pulumi.azurenative.streamanalytics.StreamingJobArgs;
 * import com.pulumi.azurenative.streamanalytics.inputs.InputArgs;
 * import com.pulumi.azurenative.streamanalytics.inputs.OutputArgs;
 * import com.pulumi.azurenative.streamanalytics.inputs.SkuArgs;
 * import com.pulumi.azurenative.streamanalytics.inputs.TransformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingJob = new StreamingJob("streamingJob", StreamingJobArgs.builder()
 *             .compatibilityLevel("1.0")
 *             .dataLocale("en-US")
 *             .eventsLateArrivalMaxDelayInSeconds(5)
 *             .eventsOutOfOrderMaxDelayInSeconds(0)
 *             .eventsOutOfOrderPolicy("Drop")
 *             .functions()
 *             .inputs(InputArgs.builder()
 *                 .name("inputtest")
 *                 .properties(StreamInputPropertiesArgs.builder()
 *                     .datasource(BlobStreamInputDataSourceArgs.builder()
 *                         .container("containerName")
 *                         .pathPattern("")
 *                         .storageAccounts(StorageAccountArgs.builder()
 *                             .accountKey("yourAccountKey==")
 *                             .accountName("yourAccountName")
 *                             .build())
 *                         .type("Microsoft.Storage/Blob")
 *                         .build())
 *                     .serialization(JsonSerializationArgs.builder()
 *                         .encoding("UTF8")
 *                         .type("Json")
 *                         .build())
 *                     .type("Stream")
 *                     .build())
 *                 .build())
 *             .jobName("sj7804")
 *             .location("West US")
 *             .outputErrorPolicy("Drop")
 *             .outputs(OutputArgs.builder()
 *                 .datasource(AzureDataLakeStoreOutputDataSourceArgs.builder()
 *                     .database("databaseName")
 *                     .password("userPassword")
 *                     .server("serverName")
 *                     .table("tableName")
 *                     .type("Microsoft.Sql/Server/Database")
 *                     .user("<user>")
 *                     .build())
 *                 .name("outputtest")
 *                 .build())
 *             .resourceGroupName("sjrg3276")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key3", "value3"),
 *                 Map.entry("randomKey", "randomValue")
 *             ))
 *             .transformation(TransformationArgs.builder()
 *                 .name("transformationtest")
 *                 .query("Select Id, Name from inputtest")
 *                 .streamingUnits(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create a streaming job shell (a streaming job with no inputs, outputs, transformation, or functions)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingJob = new AzureNative.StreamAnalytics.StreamingJob("streamingJob", new()
 *     {
 *         CompatibilityLevel = AzureNative.StreamAnalytics.CompatibilityLevel.CompatibilityLevel_1_0,
 *         DataLocale = "en-US",
 *         EventsLateArrivalMaxDelayInSeconds = 16,
 *         EventsOutOfOrderMaxDelayInSeconds = 5,
 *         EventsOutOfOrderPolicy = AzureNative.StreamAnalytics.EventsOutOfOrderPolicy.Drop,
 *         Functions = new[] {},
 *         Inputs = new[] {},
 *         JobName = "sj59",
 *         Location = "West US",
 *         OutputErrorPolicy = AzureNative.StreamAnalytics.OutputErrorPolicy.Drop,
 *         Outputs = new[] {},
 *         ResourceGroupName = "sjrg6936",
 *         Sku = new AzureNative.StreamAnalytics.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.StreamAnalytics.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key3", "value3" },
 *             { "randomKey", "randomValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/streamanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := streamanalytics.NewStreamingJob(ctx, "streamingJob", &streamanalytics.StreamingJobArgs{
 * 			CompatibilityLevel:                 pulumi.String(streamanalytics.CompatibilityLevel_1_0),
 * 			DataLocale:                         pulumi.String("en-US"),
 * 			EventsLateArrivalMaxDelayInSeconds: pulumi.Int(16),
 * 			EventsOutOfOrderMaxDelayInSeconds:  pulumi.Int(5),
 * 			EventsOutOfOrderPolicy:             pulumi.String(streamanalytics.EventsOutOfOrderPolicyDrop),
 * 			Functions:                          streamanalytics.FunctionTypeArray{},
 * 			Inputs:                             streamanalytics.InputTypeArray{},
 * 			JobName:                            pulumi.String("sj59"),
 * 			Location:                           pulumi.String("West US"),
 * 			OutputErrorPolicy:                  pulumi.String(streamanalytics.OutputErrorPolicyDrop),
 * 			Outputs:                            streamanalytics.OutputTypeArray{},
 * 			ResourceGroupName:                  pulumi.String("sjrg6936"),
 * 			Sku: &streamanalytics.SkuArgs{
 * 				Name: pulumi.String(streamanalytics.SkuNameStandard),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1":      pulumi.String("value1"),
 * 				"key3":      pulumi.String("value3"),
 * 				"randomKey": pulumi.String("randomValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.streamanalytics.StreamingJob;
 * import com.pulumi.azurenative.streamanalytics.StreamingJobArgs;
 * import com.pulumi.azurenative.streamanalytics.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingJob = new StreamingJob("streamingJob", StreamingJobArgs.builder()
 *             .compatibilityLevel("1.0")
 *             .dataLocale("en-US")
 *             .eventsLateArrivalMaxDelayInSeconds(16)
 *             .eventsOutOfOrderMaxDelayInSeconds(5)
 *             .eventsOutOfOrderPolicy("Drop")
 *             .functions()
 *             .inputs()
 *             .jobName("sj59")
 *             .location("West US")
 *             .outputErrorPolicy("Drop")
 *             .outputs()
 *             .resourceGroupName("sjrg6936")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key3", "value3"),
 *                 Map.entry("randomKey", "randomValue")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:streamanalytics:StreamingJob sj59 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}
 * ```
 */
public class StreamingJob internal constructor(
    override val javaResource: com.pulumi.azurenative.streamanalytics.StreamingJob,
) : KotlinCustomResource(javaResource, StreamingJobMapper) {
    /**
     * The cluster which streaming jobs will run on.
     */
    public val cluster: Output<ClusterInfoResponse>?
        get() = javaResource.cluster().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Controls certain runtime behaviors of the streaming job.
     */
    public val compatibilityLevel: Output<String>?
        get() = javaResource.compatibilityLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Valid values are JobStorageAccount and SystemAccount. If set to JobStorageAccount, this requires the user to also specify jobStorageAccount property. .
     */
    public val contentStoragePolicy: Output<String>?
        get() = javaResource.contentStoragePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Value is an ISO-8601 formatted UTC timestamp indicating when the streaming job was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * The data locale of the stream analytics job. Value should be the name of a supported .NET Culture from the set https://msdn.microsoft.com/en-us/library/system.globalization.culturetypes(v=vs.110).aspx. Defaults to 'en-US' if none specified.
     */
    public val dataLocale: Output<String>?
        get() = javaResource.dataLocale().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The current entity tag for the streaming job. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The maximum tolerable delay in seconds where events arriving late could be included.  Supported range is -1 to 1814399 (20.23:59:59 days) and -1 is used to specify wait indefinitely. If the property is absent, it is interpreted to have a value of -1.
     */
    public val eventsLateArrivalMaxDelayInSeconds: Output<Int>?
        get() = javaResource.eventsLateArrivalMaxDelayInSeconds().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The maximum tolerable delay in seconds where out-of-order events can be adjusted to be back in order.
     */
    public val eventsOutOfOrderMaxDelayInSeconds: Output<Int>?
        get() = javaResource.eventsOutOfOrderMaxDelayInSeconds().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Indicates the policy to apply to events that arrive out of order in the input event stream.
     */
    public val eventsOutOfOrderPolicy: Output<String>?
        get() = javaResource.eventsOutOfOrderPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of one or more functions for the streaming job. The name property for each function is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    public val functions: Output<List<FunctionResponse>>?
        get() = javaResource.functions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> functionResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Describes the system-assigned managed identity assigned to this job that can be used to authenticate with inputs and outputs.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A list of one or more inputs to the streaming job. The name property for each input is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual input.
     */
    public val inputs: Output<List<InputResponse>>?
        get() = javaResource.inputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> inputResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A GUID uniquely identifying the streaming job. This GUID is generated upon creation of the streaming job.
     */
    public val jobId: Output<String>
        get() = javaResource.jobId().applyValue({ args0 -> args0 })

    /**
     * Describes the state of the streaming job.
     */
    public val jobState: Output<String>
        get() = javaResource.jobState().applyValue({ args0 -> args0 })

    /**
     * The properties that are associated with an Azure Storage account with MSI
     */
    public val jobStorageAccount: Output<JobStorageAccountResponse>?
        get() = javaResource.jobStorageAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jobStorageAccountResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Describes the type of the job. Valid modes are `Cloud` and 'Edge'.
     */
    public val jobType: Output<String>?
        get() = javaResource.jobType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Value is either an ISO-8601 formatted timestamp indicating the last output event time of the streaming job or null indicating that output has not yet been produced. In case of multiple outputs or multiple streams, this shows the latest value in that set.
     */
    public val lastOutputEventTime: Output<String>
        get() = javaResource.lastOutputEventTime().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size).
     */
    public val outputErrorPolicy: Output<String>?
        get() = javaResource.outputErrorPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This property should only be utilized when it is desired that the job be started immediately upon creation. Value may be JobStartTime, CustomTime, or LastOutputEventTime to indicate whether the starting point of the output event stream should start whenever the job is started, start at a custom user time stamp specified via the outputStartTime property, or start from the last event output time.
     */
    public val outputStartMode: Output<String>?
        get() = javaResource.outputStartMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Value is either an ISO-8601 formatted time stamp that indicates the starting point of the output event stream, or null to indicate that the output event stream will start whenever the streaming job is started. This property must have a value if outputStartMode is set to CustomTime.
     */
    public val outputStartTime: Output<String>?
        get() = javaResource.outputStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of one or more outputs for the streaming job. The name property for each output is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual output.
     */
    public val outputs: Output<List<OutputResponse>>?
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> outputResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Describes the provisioning status of the streaming job.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Describes the SKU of the streaming job. Required on PUT (CreateOrReplace) requests.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Indicates the query and the number of streaming units to use for the streaming job. The name property of the transformation is required when specifying this property in a PUT request. This property cannot be modify via a PATCH operation. You must use the PATCH API available for the individual transformation.
     */
    public val transformation: Output<TransformationResponse>?
        get() = javaResource.transformation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> transformationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StreamingJobMapper : ResourceMapper<StreamingJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.streamanalytics.StreamingJob::class == javaResource::class

    override fun map(javaResource: Resource): StreamingJob = StreamingJob(
        javaResource as
            com.pulumi.azurenative.streamanalytics.StreamingJob,
    )
}

/**
 * @see [StreamingJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StreamingJob].
 */
public suspend fun streamingJob(
    name: String,
    block: suspend StreamingJobResourceBuilder.() -> Unit,
): StreamingJob {
    val builder = StreamingJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StreamingJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun streamingJob(name: String): StreamingJob {
    val builder = StreamingJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
