@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the type of compression that the input uses. Required on PUT (CreateOrReplace) requests.
 */
public enum class CompressionType(
    public val javaValue: com.pulumi.azurenative.streamanalytics.enums.CompressionType,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.enums.CompressionType> {
    None(com.pulumi.azurenative.streamanalytics.enums.CompressionType.None),
    GZip(com.pulumi.azurenative.streamanalytics.enums.CompressionType.GZip),
    Deflate(com.pulumi.azurenative.streamanalytics.enums.CompressionType.Deflate),
    ;

    override fun toJava(): com.pulumi.azurenative.streamanalytics.enums.CompressionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.enums.CompressionType): CompressionType = CompressionType.values().first { it.javaValue == javaType }
    }
}
