@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
 */
public enum class Encoding(
    public val javaValue: com.pulumi.azurenative.streamanalytics.enums.Encoding,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.enums.Encoding> {
    UTF8(com.pulumi.azurenative.streamanalytics.enums.Encoding.UTF8),
    ;

    override fun toJava(): com.pulumi.azurenative.streamanalytics.enums.Encoding = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.enums.Encoding): Encoding =
            Encoding.values().first { it.javaValue == javaType }
    }
}
