@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the policy to apply to events that arrive at the output and cannot be written to the external storage due to being malformed (missing column values, column values of wrong type or size).
 */
public enum class OutputErrorPolicy(
    public val javaValue: com.pulumi.azurenative.streamanalytics.enums.OutputErrorPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.enums.OutputErrorPolicy> {
    Stop(com.pulumi.azurenative.streamanalytics.enums.OutputErrorPolicy.Stop),
    Drop(com.pulumi.azurenative.streamanalytics.enums.OutputErrorPolicy.Drop),
    ;

    override fun toJava(): com.pulumi.azurenative.streamanalytics.enums.OutputErrorPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.enums.OutputErrorPolicy): OutputErrorPolicy = OutputErrorPolicy.values().first { it.javaValue == javaType }
    }
}
