@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceFunctionBindingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The binding to an Azure Machine Learning web service.
 * @property apiKey The API key used to authenticate with Request-Response endpoint.
 * @property batchSize Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
 * @property endpoint The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
 * @property inputs The inputs for the Azure Machine Learning web service endpoint.
 * @property outputs A list of outputs from the Azure Machine Learning web service endpoint execution.
 * @property type Indicates the function binding type.
 * Expected value is 'Microsoft.MachineLearning/WebService'.
 */
public data class AzureMachineLearningWebServiceFunctionBindingArgs(
    public val apiKey: Output<String>? = null,
    public val batchSize: Output<Int>? = null,
    public val endpoint: Output<String>? = null,
    public val inputs: Output<AzureMachineLearningWebServiceInputsArgs>? = null,
    public val outputs: Output<List<AzureMachineLearningWebServiceOutputColumnArgs>>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceFunctionBindingArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceFunctionBindingArgs =
        com.pulumi.azurenative.streamanalytics.inputs.AzureMachineLearningWebServiceFunctionBindingArgs.builder()
            .apiKey(apiKey?.applyValue({ args0 -> args0 }))
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .inputs(inputs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outputs(
                outputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureMachineLearningWebServiceFunctionBindingArgs].
 */
@PulumiTagMarker
public class AzureMachineLearningWebServiceFunctionBindingArgsBuilder internal constructor() {
    private var apiKey: Output<String>? = null

    private var batchSize: Output<Int>? = null

    private var endpoint: Output<String>? = null

    private var inputs: Output<AzureMachineLearningWebServiceInputsArgs>? = null

    private var outputs: Output<List<AzureMachineLearningWebServiceOutputColumnArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The API key used to authenticate with Request-Response endpoint.
     */
    @JvmName("brdqyxjqiycdlnrp")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
     */
    @JvmName("ixmjdgufgdbnempy")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
     */
    @JvmName("lvnqevmmfvvlbqmf")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The inputs for the Azure Machine Learning web service endpoint.
     */
    @JvmName("hguolcstjjfcrrta")
    public suspend fun inputs(`value`: Output<AzureMachineLearningWebServiceInputsArgs>) {
        this.inputs = value
    }

    /**
     * @param value A list of outputs from the Azure Machine Learning web service endpoint execution.
     */
    @JvmName("fajxpefienfkrgbc")
    public suspend fun outputs(`value`: Output<List<AzureMachineLearningWebServiceOutputColumnArgs>>) {
        this.outputs = value
    }

    @JvmName("qjklbgpffllomwct")
    public suspend fun outputs(vararg values: Output<AzureMachineLearningWebServiceOutputColumnArgs>) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values A list of outputs from the Azure Machine Learning web service endpoint execution.
     */
    @JvmName("udaysxdxkarwrkoi")
    public suspend fun outputs(values: List<Output<AzureMachineLearningWebServiceOutputColumnArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value Indicates the function binding type.
     * Expected value is 'Microsoft.MachineLearning/WebService'.
     */
    @JvmName("ovmtimpctwhsadvq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The API key used to authenticate with Request-Response endpoint.
     */
    @JvmName("yomjgcbmtfbwaoae")
    public suspend fun apiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
     */
    @JvmName("tgrkmhuukbvjsuov")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
     */
    @JvmName("bwfbussllfxetldq")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The inputs for the Azure Machine Learning web service endpoint.
     */
    @JvmName("adrqjigaxsbkhlgs")
    public suspend fun inputs(`value`: AzureMachineLearningWebServiceInputsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param argument The inputs for the Azure Machine Learning web service endpoint.
     */
    @JvmName("wpkvqkivsxdjgemk")
    public suspend fun inputs(argument: suspend AzureMachineLearningWebServiceInputsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureMachineLearningWebServiceInputsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param value A list of outputs from the Azure Machine Learning web service endpoint execution.
     */
    @JvmName("pjrtbgnrlvevqgbh")
    public suspend fun outputs(`value`: List<AzureMachineLearningWebServiceOutputColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument A list of outputs from the Azure Machine Learning web service endpoint execution.
     */
    @JvmName("xrkcneotyjkhwfih")
    public suspend fun outputs(argument: List<suspend AzureMachineLearningWebServiceOutputColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureMachineLearningWebServiceOutputColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument A list of outputs from the Azure Machine Learning web service endpoint execution.
     */
    @JvmName("ukufdtqxamdtpymn")
    public suspend fun outputs(vararg argument: suspend AzureMachineLearningWebServiceOutputColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureMachineLearningWebServiceOutputColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument A list of outputs from the Azure Machine Learning web service endpoint execution.
     */
    @JvmName("tsgduotxiendvlnv")
    public suspend fun outputs(argument: suspend AzureMachineLearningWebServiceOutputColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureMachineLearningWebServiceOutputColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values A list of outputs from the Azure Machine Learning web service endpoint execution.
     */
    @JvmName("akswjmvfjgnekemh")
    public suspend fun outputs(vararg values: AzureMachineLearningWebServiceOutputColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value Indicates the function binding type.
     * Expected value is 'Microsoft.MachineLearning/WebService'.
     */
    @JvmName("dbqvicbdkgivrhla")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureMachineLearningWebServiceFunctionBindingArgs =
        AzureMachineLearningWebServiceFunctionBindingArgs(
            apiKey = apiKey,
            batchSize = batchSize,
            endpoint = endpoint,
            inputs = inputs,
            outputs = outputs,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
