@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.FunctionArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A function object, containing all information associated with the named function. All functions are contained under a streaming job.
 * @property name Resource name
 * @property properties The properties that are associated with a function.
 */
public data class FunctionArgs(
    public val name: Output<String>? = null,
    public val properties: Output<Either<AggregateFunctionPropertiesArgs, ScalarFunctionPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.FunctionArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.FunctionArgs =
        com.pulumi.azurenative.streamanalytics.inputs.FunctionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [FunctionArgs].
 */
@PulumiTagMarker
public class FunctionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var properties:
        Output<Either<AggregateFunctionPropertiesArgs, ScalarFunctionPropertiesArgs>>? = null

    /**
     * @param value Resource name
     */
    @JvmName("bjwolmrxmwtubxwc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The properties that are associated with a function.
     */
    @JvmName("agqkgleixljpikox")
    public suspend fun properties(`value`: Output<Either<AggregateFunctionPropertiesArgs, ScalarFunctionPropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value Resource name
     */
    @JvmName("ajjhlayeewyteqge")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The properties that are associated with a function.
     */
    @JvmName("gawjuiqkmeausgao")
    public suspend fun properties(`value`: Either<AggregateFunctionPropertiesArgs, ScalarFunctionPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that are associated with a function.
     */
    @JvmName("sbungcdmthxiukxc")
    public fun properties(`value`: AggregateFunctionPropertiesArgs) {
        val toBeMapped = Either.ofLeft<
            AggregateFunctionPropertiesArgs,
            ScalarFunctionPropertiesArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that are associated with a function.
     */
    @JvmName("baxrotmdgkqbfcyg")
    public fun properties(`value`: ScalarFunctionPropertiesArgs) {
        val toBeMapped = Either.ofRight<
            AggregateFunctionPropertiesArgs,
            ScalarFunctionPropertiesArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): FunctionArgs = FunctionArgs(
        name = name,
        properties = properties,
    )
}
