@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.GetFunctionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionName The name of the function.
 * @property jobName The name of the streaming job.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetFunctionPlainArgs(
    public val functionName: String,
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.GetFunctionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.GetFunctionPlainArgs =
        com.pulumi.azurenative.streamanalytics.inputs.GetFunctionPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFunctionPlainArgs].
 */
@PulumiTagMarker
public class GetFunctionPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the function.
     */
    @JvmName("ltwtsnivhnlnbjdh")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("vcibdiwcsxkcnkis")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nksfwxyqfkowunqc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFunctionPlainArgs = GetFunctionPlainArgs(
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
