@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.GetStreamingJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The $expand OData query parameter. This is a comma-separated list of additional streaming job properties to include in the response, beyond the default set returned when this parameter is absent. The default set is all streaming job properties other than 'inputs', 'transformation', 'outputs', and 'functions'.
 * @property jobName The name of the streaming job.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetStreamingJobPlainArgs(
    public val expand: String? = null,
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.GetStreamingJobPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.GetStreamingJobPlainArgs =
        com.pulumi.azurenative.streamanalytics.inputs.GetStreamingJobPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStreamingJobPlainArgs].
 */
@PulumiTagMarker
public class GetStreamingJobPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The $expand OData query parameter. This is a comma-separated list of additional streaming job properties to include in the response, beyond the default set returned when this parameter is absent. The default set is all streaming job properties other than 'inputs', 'transformation', 'outputs', and 'functions'.
     */
    @JvmName("sdrevbtiyeawihjk")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the streaming job.
     */
    @JvmName("cypkjbejiylmgxhd")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kcxuqgjmkehvgcfb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetStreamingJobPlainArgs = GetStreamingJobPlainArgs(
        expand = expand,
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
