@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.InputArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An input object, containing all information associated with the named input. All inputs are contained under a streaming job.
 * @property name Resource name
 * @property properties The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
 */
public data class InputArgs(
    public val name: Output<String>? = null,
    public val properties: Output<Either<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.InputArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.InputArgs =
        com.pulumi.azurenative.streamanalytics.inputs.InputArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [InputArgs].
 */
@PulumiTagMarker
public class InputArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var properties: Output<Either<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>>? =
        null

    /**
     * @param value Resource name
     */
    @JvmName("tklwfvyxnotbsarr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("dfpbbgipueblbrmf")
    public suspend fun properties(`value`: Output<Either<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value Resource name
     */
    @JvmName("lxfpsvdvnpvtbepe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("jyklxghqnbrpikyr")
    public suspend fun properties(`value`: Either<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("takmnsinbaxeclke")
    public fun properties(`value`: ReferenceInputPropertiesArgs) {
        val toBeMapped = Either.ofLeft<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("pfmgubpiqsihpplo")
    public fun properties(`value`: StreamInputPropertiesArgs) {
        val toBeMapped = Either.ofRight<ReferenceInputPropertiesArgs, StreamInputPropertiesArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): InputArgs = InputArgs(
        name = name,
        properties = properties,
    )
}
