@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.IoTHubStreamInputDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes an IoT Hub input data source that contains stream data.
 * @property consumerGroupName The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
 * @property endpoint The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
 * @property iotHubNamespace The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Devices/IotHubs'.
 */
public data class IoTHubStreamInputDataSourceArgs(
    public val consumerGroupName: Output<String>? = null,
    public val endpoint: Output<String>? = null,
    public val iotHubNamespace: Output<String>? = null,
    public val sharedAccessPolicyKey: Output<String>? = null,
    public val sharedAccessPolicyName: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.IoTHubStreamInputDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.IoTHubStreamInputDataSourceArgs =
        com.pulumi.azurenative.streamanalytics.inputs.IoTHubStreamInputDataSourceArgs.builder()
            .consumerGroupName(consumerGroupName?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .iotHubNamespace(iotHubNamespace?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyKey(sharedAccessPolicyKey?.applyValue({ args0 -> args0 }))
            .sharedAccessPolicyName(sharedAccessPolicyName?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IoTHubStreamInputDataSourceArgs].
 */
@PulumiTagMarker
public class IoTHubStreamInputDataSourceArgsBuilder internal constructor() {
    private var consumerGroupName: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var iotHubNamespace: Output<String>? = null

    private var sharedAccessPolicyKey: Output<String>? = null

    private var sharedAccessPolicyName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
     */
    @JvmName("stmnlwypavhrvpvi")
    public suspend fun consumerGroupName(`value`: Output<String>) {
        this.consumerGroupName = value
    }

    /**
     * @param value The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
     */
    @JvmName("nfwongjhtamelttn")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("uosleqodvirmnksk")
    public suspend fun iotHubNamespace(`value`: Output<String>) {
        this.iotHubNamespace = value
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ooaagliujxgfwnuc")
    public suspend fun sharedAccessPolicyKey(`value`: Output<String>) {
        this.sharedAccessPolicyKey = value
    }

    /**
     * @param value The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("qinsabbxmpdkbloy")
    public suspend fun sharedAccessPolicyName(`value`: Output<String>) {
        this.sharedAccessPolicyName = value
    }

    /**
     * @param value Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Devices/IotHubs'.
     */
    @JvmName("oeqmfosmbqxkhjpm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
     */
    @JvmName("fluqheqvmqfcvdfw")
    public suspend fun consumerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupName = mapped
    }

    /**
     * @param value The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
     */
    @JvmName("pvwplsyixgneonjx")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("gkkearhjuxoyhejp")
    public suspend fun iotHubNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotHubNamespace = mapped
    }

    /**
     * @param value The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("srvxmqjxnibfhnow")
    public suspend fun sharedAccessPolicyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyKey = mapped
    }

    /**
     * @param value The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("liblbdjomtfotmic")
    public suspend fun sharedAccessPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccessPolicyName = mapped
    }

    /**
     * @param value Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Microsoft.Devices/IotHubs'.
     */
    @JvmName("vbyuqkkgtdhxwqls")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IoTHubStreamInputDataSourceArgs = IoTHubStreamInputDataSourceArgs(
        consumerGroupName = consumerGroupName,
        endpoint = endpoint,
        iotHubNamespace = iotHubNamespace,
        sharedAccessPolicyKey = sharedAccessPolicyKey,
        sharedAccessPolicyName = sharedAccessPolicyName,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
