@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.JsonSerializationArgs.builder
import com.pulumi.azurenative.streamanalytics.kotlin.enums.Encoding
import com.pulumi.azurenative.streamanalytics.kotlin.enums.JsonOutputSerializationFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes how data from an input is serialized or how data is serialized when written to an output in JSON format.
 * @property encoding Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
 * @property format This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
 * @property type Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Json'.
 */
public data class JsonSerializationArgs(
    public val encoding: Output<Either<String, Encoding>>? = null,
    public val format: Output<Either<String, JsonOutputSerializationFormat>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.JsonSerializationArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.JsonSerializationArgs =
        com.pulumi.azurenative.streamanalytics.inputs.JsonSerializationArgs.builder()
            .encoding(
                encoding?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JsonSerializationArgs].
 */
@PulumiTagMarker
public class JsonSerializationArgsBuilder internal constructor() {
    private var encoding: Output<Either<String, Encoding>>? = null

    private var format: Output<Either<String, JsonOutputSerializationFormat>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("bgbqimteoaeygbvj")
    public suspend fun encoding(`value`: Output<Either<String, Encoding>>) {
        this.encoding = value
    }

    /**
     * @param value This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
     */
    @JvmName("tghxrynkgxprbllx")
    public suspend fun format(`value`: Output<Either<String, JsonOutputSerializationFormat>>) {
        this.format = value
    }

    /**
     * @param value Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Json'.
     */
    @JvmName("xjdghvljypkcjuoe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("ducdmgxnwkhbedmm")
    public suspend fun encoding(`value`: Either<String, Encoding>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("xjbfcobmxdylxecm")
    public fun encoding(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Encoding>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("jrawlxdudtswteia")
    public fun encoding(`value`: Encoding) {
        val toBeMapped = Either.ofRight<String, Encoding>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
     */
    @JvmName("lajkmrmedqfdredn")
    public suspend fun format(`value`: Either<String, JsonOutputSerializationFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
     */
    @JvmName("tqlcnpxvmfsdmqci")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JsonOutputSerializationFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
     */
    @JvmName("yproebxylfmwkvmu")
    public fun format(`value`: JsonOutputSerializationFormat) {
        val toBeMapped = Either.ofRight<String, JsonOutputSerializationFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
     * Expected value is 'Json'.
     */
    @JvmName("odeoqrauuchsdoao")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JsonSerializationArgs = JsonSerializationArgs(
        encoding = encoding,
        format = format,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
