@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.inputs

import com.pulumi.azurenative.streamanalytics.inputs.TransformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A transformation object, containing all information associated with the named transformation. All transformations are contained under a streaming job.
 * @property name Resource name
 * @property query Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
 * @property streamingUnits Specifies the number of streaming units that the streaming job uses.
 * @property validStreamingUnits Specifies the valid streaming units a streaming job can scale to.
 */
public data class TransformationArgs(
    public val name: Output<String>? = null,
    public val query: Output<String>? = null,
    public val streamingUnits: Output<Int>? = null,
    public val validStreamingUnits: Output<List<Int>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.streamanalytics.inputs.TransformationArgs> {
    override fun toJava(): com.pulumi.azurenative.streamanalytics.inputs.TransformationArgs =
        com.pulumi.azurenative.streamanalytics.inputs.TransformationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .streamingUnits(streamingUnits?.applyValue({ args0 -> args0 }))
            .validStreamingUnits(
                validStreamingUnits?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [TransformationArgs].
 */
@PulumiTagMarker
public class TransformationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var query: Output<String>? = null

    private var streamingUnits: Output<Int>? = null

    private var validStreamingUnits: Output<List<Int>>? = null

    /**
     * @param value Resource name
     */
    @JvmName("hgvmfhalxxhhpvpt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("maojeqkljrjtwekx")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value Specifies the number of streaming units that the streaming job uses.
     */
    @JvmName("xoiviyxgxmcnsfhu")
    public suspend fun streamingUnits(`value`: Output<Int>) {
        this.streamingUnits = value
    }

    /**
     * @param value Specifies the valid streaming units a streaming job can scale to.
     */
    @JvmName("chdkiqhsjkwaivxl")
    public suspend fun validStreamingUnits(`value`: Output<List<Int>>) {
        this.validStreamingUnits = value
    }

    @JvmName("cjjeukxkbmcapdvx")
    public suspend fun validStreamingUnits(vararg values: Output<Int>) {
        this.validStreamingUnits = Output.all(values.asList())
    }

    /**
     * @param values Specifies the valid streaming units a streaming job can scale to.
     */
    @JvmName("lceelrhhxkasgeos")
    public suspend fun validStreamingUnits(values: List<Output<Int>>) {
        this.validStreamingUnits = Output.all(values)
    }

    /**
     * @param value Resource name
     */
    @JvmName("msggvefbnpptgwwl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
     */
    @JvmName("dpbhstuhuhjfwycv")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value Specifies the number of streaming units that the streaming job uses.
     */
    @JvmName("rvrabwfjqaadbveq")
    public suspend fun streamingUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingUnits = mapped
    }

    /**
     * @param value Specifies the valid streaming units a streaming job can scale to.
     */
    @JvmName("athymsiknrssihgu")
    public suspend fun validStreamingUnits(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validStreamingUnits = mapped
    }

    /**
     * @param values Specifies the valid streaming units a streaming job can scale to.
     */
    @JvmName("wpkthbnbumgvnwda")
    public suspend fun validStreamingUnits(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validStreamingUnits = mapped
    }

    internal fun build(): TransformationArgs = TransformationArgs(
        name = name,
        query = query,
        streamingUnits = streamingUnits,
        validStreamingUnits = validStreamingUnits,
    )
}
