@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties that are associated with an aggregate function.
 * @property binding The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
 * @property etag The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
 * @property inputs
 * @property output Describes the output of a function.
 * @property type Indicates the type of function.
 * Expected value is 'Aggregate'.
 */
public data class AggregateFunctionPropertiesResponse(
    public val binding: Either<AzureMachineLearningWebServiceFunctionBindingResponse, JavaScriptFunctionBindingResponse>? =
        null,
    public val etag: String,
    public val inputs: List<FunctionInputResponse>? = null,
    public val output: FunctionOutputResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AggregateFunctionPropertiesResponse): AggregateFunctionPropertiesResponse = AggregateFunctionPropertiesResponse(
            binding = javaType.binding().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.streamanalytics.kotlin.outputs.AzureMachineLearningWebServiceFunctionBindingResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.streamanalytics.kotlin.outputs.JavaScriptFunctionBindingResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            etag = javaType.etag(),
            inputs = javaType.inputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.FunctionInputResponse.Companion.toKotlin(args0)
                })
            }),
            output = javaType.output().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.FunctionOutputResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
