@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes how data from an input is serialized or how data is serialized when written to an output in Avro format.
 * @property type Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Avro'.
 */
public data class AvroSerializationResponse(
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AvroSerializationResponse): AvroSerializationResponse = AvroSerializationResponse(
            type = javaType.type(),
        )
    }
}
