@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Defines the metadata of AzureFunctionOutputDataSource
 * @property apiKey If you want to use an Azure Function from another subscription, you can do so by providing the key to access your function.
 * @property functionAppName The name of your Azure Functions app.
 * @property functionName The name of the function in your Azure Functions app.
 * @property maxBatchCount A property that lets you specify the maximum number of events in each batch that's sent to Azure Functions. The default value is 100.
 * @property maxBatchSize A property that lets you set the maximum size for each output batch that's sent to your Azure function. The input unit is in bytes. By default, this value is 262,144 bytes (256 KB).
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.AzureFunction'.
 */
public data class AzureFunctionOutputDataSourceResponse(
    public val apiKey: String? = null,
    public val functionAppName: String? = null,
    public val functionName: String? = null,
    public val maxBatchCount: Double? = null,
    public val maxBatchSize: Double? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureFunctionOutputDataSourceResponse): AzureFunctionOutputDataSourceResponse = AzureFunctionOutputDataSourceResponse(
            apiKey = javaType.apiKey().map({ args0 -> args0 }).orElse(null),
            functionAppName = javaType.functionAppName().map({ args0 -> args0 }).orElse(null),
            functionName = javaType.functionName().map({ args0 -> args0 }).orElse(null),
            maxBatchCount = javaType.maxBatchCount().map({ args0 -> args0 }).orElse(null),
            maxBatchSize = javaType.maxBatchSize().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
