@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes an input column for the Azure Machine Learning web service endpoint.
 * @property dataType The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
 * @property mapTo The zero based index of the function parameter this input maps to.
 * @property name The name of the input column.
 */
public data class AzureMachineLearningWebServiceInputColumnResponse(
    public val dataType: String? = null,
    public val mapTo: Int? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureMachineLearningWebServiceInputColumnResponse): AzureMachineLearningWebServiceInputColumnResponse =
            AzureMachineLearningWebServiceInputColumnResponse(
                dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
                mapTo = javaType.mapTo().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
