@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The inputs for the Azure Machine Learning web service endpoint.
 * @property columnNames A list of input columns for the Azure Machine Learning web service endpoint.
 * @property name The name of the input. This is the name provided while authoring the endpoint.
 */
public data class AzureMachineLearningWebServiceInputsResponse(
    public val columnNames: List<AzureMachineLearningWebServiceInputColumnResponse>? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.AzureMachineLearningWebServiceInputsResponse): AzureMachineLearningWebServiceInputsResponse = AzureMachineLearningWebServiceInputsResponse(
            columnNames = javaType.columnNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.AzureMachineLearningWebServiceInputColumnResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
