@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes a blob output data source.
 * @property authenticationMode Authentication Mode.
 * @property blobPathPrefix Blob path prefix.
 * @property container The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
 * @property dateFormat The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
 * @property pathPattern The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
 * @property storageAccounts A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
 * @property timeFormat The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Storage/Blob'.
 */
public data class BlobOutputDataSourceResponse(
    public val authenticationMode: String? = null,
    public val blobPathPrefix: String? = null,
    public val container: String? = null,
    public val dateFormat: String? = null,
    public val pathPattern: String? = null,
    public val storageAccounts: List<StorageAccountResponse>? = null,
    public val timeFormat: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.BlobOutputDataSourceResponse): BlobOutputDataSourceResponse = BlobOutputDataSourceResponse(
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            blobPathPrefix = javaType.blobPathPrefix().map({ args0 -> args0 }).orElse(null),
            container = javaType.container().map({ args0 -> args0 }).orElse(null),
            dateFormat = javaType.dateFormat().map({ args0 -> args0 }).orElse(null),
            pathPattern = javaType.pathPattern().map({ args0 -> args0 }).orElse(null),
            storageAccounts = javaType.storageAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.StorageAccountResponse.Companion.toKotlin(args0)
                })
            }),
            timeFormat = javaType.timeFormat().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
